/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.springrabbit.MessagePropertiesConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;

public class DefaultMessagePropertiesConverter
implements MessagePropertiesConverter {
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public MessageProperties toMessageProperties(Exchange exchange) {
        String clusterId;
        Integer priority;
        String appId;
        String userId;
        Date timestamp;
        String expiration;
        String replyTo;
        String correlationId;
        String messageId;
        String contentEncoding;
        Long contentLength;
        String contentType;
        String type;
        MessageProperties answer = new MessageProperties();
        Message message = exchange.getMessage();
        MessageDeliveryMode deliveryMode = message.getHeader("CamelSpringRabbitmqDeliveryMode", MessageDeliveryMode.class);
        if (deliveryMode != null) {
            answer.setDeliveryMode(deliveryMode);
        }
        if ((type = message.getHeader("CamelSpringRabbitmqType", String.class)) != null) {
            answer.setType(type);
        }
        if ((contentType = message.getHeader("CamelSpringRabbitmqContentType", String.class)) != null) {
            answer.setContentType(contentType);
        }
        if ((contentLength = message.getHeader("CamelSpringRabbitmqContentLength", Long.class)) != null) {
            answer.setContentLength(contentLength);
        }
        if ((contentEncoding = message.getHeader("CamelSpringRabbitmqContentEncoding", String.class)) != null) {
            answer.setContentEncoding(contentEncoding);
        }
        if ((messageId = message.getHeader("CamelSpringRabbitmqMessageId", String.class)) != null) {
            answer.setMessageId(messageId);
        }
        if ((correlationId = message.getHeader("CamelSpringRabbitmqCorrelationId", String.class)) != null) {
            answer.setCorrelationId(correlationId);
        }
        if ((replyTo = message.getHeader("CamelSpringRabbitmqReplyTo", String.class)) != null) {
            answer.setReplyTo(replyTo);
        }
        if ((expiration = message.getHeader("CamelSpringRabbitmqExpiration", String.class)) != null) {
            answer.setExpiration(expiration);
        }
        if ((timestamp = message.getHeader("CamelSpringRabbitmqTimestamp", Date.class)) != null) {
            answer.setTimestamp(timestamp);
        }
        if ((userId = message.getHeader("CamelSpringRabbitmqUserId", String.class)) != null) {
            answer.setUserId(userId);
        }
        if ((appId = message.getHeader("CamelSpringRabbitmqAppId", String.class)) != null) {
            answer.setAppId(appId);
        }
        if ((priority = message.getHeader("CamelSpringRabbitmqPriority", Integer.class)) != null) {
            answer.setPriority(priority);
        }
        if ((clusterId = message.getHeader("CamelSpringRabbitmqClusterId", String.class)) != null) {
            answer.setClusterId(clusterId);
        }
        Set<Map.Entry<String, Object>> entries = message.getHeaders().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String headerName = entry.getKey();
            Object headerValue = entry.getValue();
            this.appendOutputHeader(answer, headerName, headerValue, exchange);
        }
        return answer;
    }

    @Override
    public Map<String, Object> fromMessageProperties(MessageProperties messageProperties, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        if (messageProperties != null) {
            Set<Map.Entry<String, Object>> entries = messageProperties.getHeaders().entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String headerName = entry.getKey();
                Object headerValue = entry.getValue();
                this.appendInputHeader(answer, headerName, headerValue, exchange);
            }
            if (messageProperties.getRedelivered() != null) {
                answer.put("CamelSpringRabbitmqRedelivered", messageProperties.getRedelivered());
            }
            if (messageProperties.getDeliveryTag() > 0L) {
                answer.put("CamelSpringRabbitmqDeliveryTag", messageProperties.getDeliveryTag());
            }
            if (messageProperties.getReceivedExchange() != null) {
                answer.put("CamelSpringRabbitmqExchangeName", messageProperties.getReceivedExchange());
            }
            if (messageProperties.getReceivedRoutingKey() != null) {
                answer.put("CamelSpringRabbitmqRoutingKey", messageProperties.getReceivedRoutingKey());
            }
            if (messageProperties.getReceivedDeliveryMode() != null) {
                answer.put("CamelSpringRabbitmqDeliveryMode", (Object)messageProperties.getReceivedDeliveryMode());
            }
            if (messageProperties.getType() != null) {
                answer.put("CamelSpringRabbitmqType", messageProperties.getType());
            }
            if (messageProperties.getContentType() != null) {
                answer.put("CamelSpringRabbitmqContentType", messageProperties.getContentType());
            }
            if (messageProperties.getContentLength() > 0L) {
                answer.put("CamelSpringRabbitmqContentLength", messageProperties.getContentLength());
            }
            if (messageProperties.getContentEncoding() != null) {
                answer.put("CamelSpringRabbitmqContentEncoding", messageProperties.getContentEncoding());
            }
            if (messageProperties.getMessageId() != null) {
                answer.put("CamelSpringRabbitmqMessageId", messageProperties.getMessageId());
            }
            if (messageProperties.getCorrelationId() != null) {
                answer.put("CamelSpringRabbitmqCorrelationId", messageProperties.getCorrelationId());
            }
            if (messageProperties.getReplyTo() != null) {
                answer.put("CamelSpringRabbitmqReplyTo", messageProperties.getReplyTo());
            }
            if (messageProperties.getExpiration() != null) {
                answer.put("CamelSpringRabbitmqExpiration", messageProperties.getExpiration());
            }
            if (messageProperties.getTimestamp() != null) {
                answer.put("CamelSpringRabbitmqTimestamp", messageProperties.getTimestamp());
            }
            if (messageProperties.getReceivedUserId() != null) {
                answer.put("CamelSpringRabbitmqUserId", messageProperties.getReceivedUserId());
            }
            if (messageProperties.getAppId() != null) {
                answer.put("CamelSpringRabbitmqAppId", messageProperties.getAppId());
            }
            if (messageProperties.getPriority() != null) {
                answer.put("CamelSpringRabbitmqPriority", messageProperties.getPriority());
            }
            if (messageProperties.getClusterId() != null) {
                answer.put("CamelSpringRabbitmqClusterId", messageProperties.getClusterId());
            }
        }
        return answer;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    private void appendOutputHeader(MessageProperties answer, String headerName, Object headerValue, Exchange ex) {
        if (this.shouldOutputHeader(headerName, headerValue, ex)) {
            answer.setHeader(headerName, headerValue);
        }
    }

    private void appendInputHeader(Map<String, Object> answer, String headerName, Object headerValue, Exchange ex) {
        if (this.shouldInputHeader(headerName, headerValue, ex)) {
            answer.put(headerName, headerValue);
        }
    }

    protected boolean shouldOutputHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }

    protected boolean shouldInputHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToExternalHeaders(headerName, headerValue, exchange);
    }
}

