/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public class CompositeContainerCustomizer<C extends MessageListenerContainer>
implements ContainerCustomizer<C> {
    private final List<ContainerCustomizer<C>> customizers = new ArrayList<ContainerCustomizer<C>>();

    public CompositeContainerCustomizer(List<ContainerCustomizer<C>> customizers) {
        Assert.notNull(customizers, "At least one customizer must be present");
        this.customizers.addAll(customizers);
    }

    @Override
    public void configure(C container) {
        this.customizers.forEach(c -> c.configure(container));
    }
}

