/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.ObjectUtils;

final class TransactionAttributeSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    @Nullable
    private TransactionAttributeSource transactionAttributeSource;

    public TransactionAttributeSourcePointcut() {
        this.setClassFilter(new TransactionAttributeSourceClassFilter());
    }

    public void setTransactionAttributeSource(@Nullable TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        return this.transactionAttributeSource == null || this.transactionAttributeSource.getTransactionAttribute(method, targetClass) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof TransactionAttributeSourcePointcut)) return false;
        TransactionAttributeSourcePointcut that = (TransactionAttributeSourcePointcut)other;
        if (!ObjectUtils.nullSafeEquals(this.transactionAttributeSource, that.transactionAttributeSource)) return false;
        return true;
    }

    public int hashCode() {
        return TransactionAttributeSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transactionAttributeSource;
    }

    private final class TransactionAttributeSourceClassFilter
    implements ClassFilter {
        private TransactionAttributeSourceClassFilter() {
        }

        @Override
        public boolean matches(Class<?> clazz) {
            if (TransactionalProxy.class.isAssignableFrom(clazz) || TransactionManager.class.isAssignableFrom(clazz) || PersistenceExceptionTranslator.class.isAssignableFrom(clazz)) {
                return false;
            }
            return TransactionAttributeSourcePointcut.this.transactionAttributeSource == null || TransactionAttributeSourcePointcut.this.transactionAttributeSource.isCandidateClass(clazz);
        }

        @Nullable
        private TransactionAttributeSource getTransactionAttributeSource() {
            return TransactionAttributeSourcePointcut.this.transactionAttributeSource;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof TransactionAttributeSourceClassFilter)) return false;
            TransactionAttributeSourceClassFilter that = (TransactionAttributeSourceClassFilter)other;
            if (!ObjectUtils.nullSafeEquals(this.getTransactionAttributeSource(), that.getTransactionAttributeSource())) return false;
            return true;
        }

        public int hashCode() {
            return TransactionAttributeSourceClassFilter.class.hashCode();
        }

        public String toString() {
            return TransactionAttributeSourceClassFilter.class.getName() + ": " + this.getTransactionAttributeSource();
        }
    }
}

