/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;

public class DefaultMessageConverter
extends AbstractMessageConverter
implements MessageConverter {
    private final String defaultCharset = Charset.defaultCharset().name();
    private final CamelContext camelContext;

    public DefaultMessageConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Message createMessage(Object body, MessageProperties messageProperties) throws MessageConversionException {
        byte[] data;
        if (body == null) {
            throw new MessageConversionException("Cannot send message as message body is null, and option allowNullBody is false.");
        }
        boolean text = body instanceof String;
        try {
            if (body instanceof String) {
                String encoding = messageProperties.getContentEncoding();
                if (encoding != null) {
                    data = ((String)body).getBytes(encoding);
                } else {
                    data = ((String)body).getBytes(this.defaultCharset);
                    messageProperties.setContentEncoding(this.defaultCharset);
                }
            } else {
                data = this.camelContext.getTypeConverter().mandatoryConvertTo(byte[].class, body);
            }
        }
        catch (UnsupportedEncodingException | NoTypeConversionAvailableException e) {
            throw new MessageConversionException("failed to convert to byte[] for rabbitmq message", e);
        }
        messageProperties.setContentLength(data.length);
        Message answer = new Message(data, messageProperties);
        if ("application/octet-stream".equals(messageProperties.getContentType()) && text) {
            messageProperties.setContentType("text/plain");
        }
        return answer;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        String contentType;
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null && (contentType = properties.getContentType()) != null && contentType.startsWith("text")) {
            String encoding = properties.getContentEncoding();
            if (encoding == null) {
                encoding = this.defaultCharset;
            }
            try {
                content = new String(message.getBody(), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageConversionException("failed to convert text-based Message content", e);
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }
}

