/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.function;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.camel.util.function.ThrowingSupplier;

public final class Suppliers {
    private Suppliers() {
    }

    public static <T> Supplier<T> memorize(final Supplier<T> supplier) {
        final AtomicReference valueHolder = new AtomicReference();
        return new Supplier<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object supplied = valueHolder.get();
                if (supplied == null) {
                    AtomicReference atomicReference = valueHolder;
                    synchronized (atomicReference) {
                        supplied = valueHolder.get();
                        if (supplied == null) {
                            supplied = Objects.requireNonNull(supplier.get(), "Supplier should not return null");
                            valueHolder.lazySet(supplied);
                        }
                    }
                }
                return supplied;
            }
        };
    }

    public static <T> Supplier<T> memorize(final ThrowingSupplier<T, ? extends Exception> supplier, final Consumer<Exception> consumer) {
        final AtomicReference valueHolder = new AtomicReference();
        return new Supplier<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object supplied = valueHolder.get();
                if (supplied == null) {
                    AtomicReference atomicReference = valueHolder;
                    synchronized (atomicReference) {
                        supplied = valueHolder.get();
                        if (supplied == null) {
                            try {
                                supplied = Objects.requireNonNull(supplier.get(), "Supplier should not return null");
                                valueHolder.lazySet(supplied);
                            }
                            catch (Exception e) {
                                consumer.accept(e);
                            }
                        }
                    }
                }
                return supplied;
            }
        };
    }

    public static <T> Supplier<T> constant(final T value) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    @SafeVarargs
    public static <T> Optional<T> firstNotNull(ThrowingSupplier<T, Exception> ... suppliers) throws Exception {
        ThrowingSupplier<T, Exception> supplier;
        Object answer = null;
        ThrowingSupplier<T, Exception>[] throwingSupplierArray = suppliers;
        int n = throwingSupplierArray.length;
        for (int j = 0; j < n && (answer = (Object)(supplier = throwingSupplierArray[j]).get()) == null; ++j) {
        }
        return Optional.ofNullable(answer);
    }

    public static <T> Optional<T> firstMatching(Predicate<T> predicate, ThrowingSupplier<T, Exception> ... suppliers) throws Exception {
        ThrowingSupplier<T, Exception> supplier;
        Object answer = null;
        ThrowingSupplier<T, Exception>[] throwingSupplierArray = suppliers;
        int n = throwingSupplierArray.length;
        for (int j = 0; j < n && !predicate.test(answer = (Object)(supplier = throwingSupplierArray[j]).get()); ++j) {
        }
        return Optional.ofNullable(answer);
    }
}

