/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Declarable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Declarables {
    private final Collection<Declarable> declarables = new ArrayList<Declarable>();

    public Declarables(Declarable ... declarables) {
        if (!ObjectUtils.isEmpty(declarables)) {
            this.declarables.addAll(Arrays.asList(declarables));
        }
    }

    public Declarables(Collection<? extends Declarable> declarables) {
        Assert.notNull(declarables, "declarables cannot be null");
        this.declarables.addAll(declarables);
    }

    public Collection<Declarable> getDeclarables() {
        return this.declarables;
    }

    public <T> List<T> getDeclarablesByType(Class<T> type) {
        return this.declarables.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public String toString() {
        return "Declarables [declarables=" + this.declarables + "]";
    }
}

