/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class AdminParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String IGNORE_DECLARATION_EXCEPTIONS = "ignore-declaration-exceptions";

    AdminParser() {
    }

    @Override
    protected String getBeanClassName(Element element) {
        return "org.springframework.amqp.rabbit.core.RabbitAdmin";
    }

    @Override
    protected boolean shouldGenerateId() {
        return false;
    }

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String attributeValue;
        String connectionFactoryRef = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        if (!StringUtils.hasText(connectionFactoryRef)) {
            parserContext.getReaderContext().error("A 'connection-factory' attribute must be set.", element);
        }
        if (StringUtils.hasText(connectionFactoryRef)) {
            builder.addConstructorArgReference(connectionFactoryRef);
        }
        if (StringUtils.hasText(attributeValue = element.getAttribute(AUTO_STARTUP_ATTRIBUTE))) {
            builder.addPropertyValue("autoStartup", attributeValue);
        }
        NamespaceUtils.setValueIfAttributeDefined(builder, element, IGNORE_DECLARATION_EXCEPTIONS);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, "explicit-declarations-only");
    }
}

