/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class AnnotationDrivenParser
implements BeanDefinitionParser {
    AnnotationDrivenParser() {
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource(element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry.containsBeanDefinition("org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor")) {
            parserContext.getReaderContext().error("Only one RabbitListenerAnnotationBeanPostProcessor may exist within the context.", source);
        } else {
            String handlerMethodFactory;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RabbitListenerAnnotationBeanPostProcessor.class);
            builder.getRawBeanDefinition().setSource(source);
            String endpointRegistry = element.getAttribute("registry");
            if (StringUtils.hasText(endpointRegistry)) {
                builder.addPropertyReference("endpointRegistry", endpointRegistry);
            } else {
                AnnotationDrivenParser.registerDefaultEndpointRegistry(source, parserContext);
            }
            String containerFactory = element.getAttribute("container-factory");
            if (StringUtils.hasText(containerFactory)) {
                builder.addPropertyValue("containerFactoryBeanName", containerFactory);
            }
            if (StringUtils.hasText(handlerMethodFactory = element.getAttribute("handler-method-factory"))) {
                builder.addPropertyReference("messageHandlerMethodFactory", handlerMethodFactory);
            }
            AnnotationDrivenParser.registerInfrastructureBean(parserContext, builder, "org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor");
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private static void registerDefaultEndpointRegistry(Object source, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RabbitListenerEndpointRegistry.class);
        builder.getRawBeanDefinition().setSource(source);
        AnnotationDrivenParser.registerInfrastructureBean(parserContext, builder, "org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry");
    }

    private static void registerInfrastructureBean(ParserContext parserContext, BeanDefinitionBuilder builder, String beanName) {
        builder.setRole(2);
        parserContext.getRegistry().registerBeanDefinition(beanName, builder.getBeanDefinition());
        BeanDefinitionHolder holder = new BeanDefinitionHolder(builder.getBeanDefinition(), beanName);
        parserContext.registerComponent(new BeanComponentDefinition(holder));
    }
}

