/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.support.ExpressionFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class NamespaceUtils {
    public static final String BASE_PACKAGE = "org.springframework.amqp.core.rabbit.config";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String ORDER = "order";

    public static boolean setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText(attributeValue)) {
            builder.addPropertyValue(propertyName, new TypedStringValue(attributeValue));
            return true;
        }
        return false;
    }

    public static boolean setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        return NamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName(attributeName));
    }

    public static boolean isAttributeDefined(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return StringUtils.hasText(value);
    }

    public static boolean addConstructorArgValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText(value)) {
            builder.addConstructorArgValue(new TypedStringValue(value));
            return true;
        }
        return false;
    }

    public static void addConstructorArgBooleanValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, boolean defaultValue) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText(value)) {
            builder.addConstructorArgValue(new TypedStringValue(value));
        } else {
            builder.addConstructorArgValue(defaultValue);
        }
    }

    public static boolean addConstructorArgRefIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText(value)) {
            builder.addConstructorArgReference(value);
            return true;
        }
        return false;
    }

    public static boolean addConstructorArgParentRefIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText(value)) {
            BeanDefinitionBuilder child = BeanDefinitionBuilder.genericBeanDefinition();
            child.setParentName(value);
            builder.addConstructorArgValue(child.getBeanDefinition());
            return true;
        }
        return false;
    }

    public static boolean setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText(attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
            return true;
        }
        return false;
    }

    public static boolean setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        return NamespaceUtils.setReferenceIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName(attributeName));
    }

    public static String createElementDescription(Element element) {
        String elementId = "'" + element.getNodeName() + "'";
        String id = element.getAttribute("id");
        if (StringUtils.hasText(id)) {
            elementId = elementId + " with id='" + id + "'";
        }
        return elementId;
    }

    public static void parseDeclarationControls(Element element, BeanDefinitionBuilder builder) {
        NamespaceUtils.setValueIfAttributeDefined(builder, element, "auto-declare", "shouldDeclare");
        String admins = element.getAttribute("declared-by");
        if (StringUtils.hasText(admins)) {
            String[] adminBeanNames = admins.split(",");
            ManagedList<RuntimeBeanReference> adminBeanRefs = new ManagedList<RuntimeBeanReference>();
            for (String adminBeanName : adminBeanNames) {
                adminBeanRefs.add(new RuntimeBeanReference(adminBeanName.trim()));
            }
            builder.addPropertyValue("adminsThatShouldDeclare", adminBeanRefs);
        }
        NamespaceUtils.setValueIfAttributeDefined(builder, element, "ignore-declaration-exceptions");
    }

    public static BeanDefinition createExpressionDefinitionFromValueOrExpression(String valueElementName, String expressionElementName, ParserContext parserContext, Element element, boolean oneRequired) {
        BeanDefinition expressionDef;
        Assert.hasText(valueElementName, "'valueElementName' must not be empty");
        Assert.hasText(expressionElementName, "'expressionElementName' must not be empty");
        String valueElementValue = element.getAttribute(valueElementName);
        String expressionElementValue = element.getAttribute(expressionElementName);
        boolean hasAttributeValue = StringUtils.hasText(valueElementValue);
        boolean hasAttributeExpression = StringUtils.hasText(expressionElementValue);
        if (hasAttributeValue && hasAttributeExpression) {
            parserContext.getReaderContext().error("Only one of '" + valueElementName + "' or '" + expressionElementName + "' is allowed", element);
        }
        if (oneRequired && !hasAttributeValue && !hasAttributeExpression) {
            parserContext.getReaderContext().error("One of '" + valueElementName + "' or '" + expressionElementName + "' is required", element);
        }
        if (hasAttributeValue) {
            expressionDef = new RootBeanDefinition(LiteralExpression.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue(valueElementValue);
        } else {
            expressionDef = NamespaceUtils.createExpressionDefIfAttributeDefined(expressionElementName, element);
        }
        return expressionDef;
    }

    public static BeanDefinition createExpressionDefIfAttributeDefined(String expressionElementName, Element element) {
        Assert.hasText(expressionElementName, "'expressionElementName' must no be empty");
        String expressionElementValue = element.getAttribute(expressionElementName);
        if (StringUtils.hasText(expressionElementValue)) {
            BeanDefinitionBuilder expressionDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionDefBuilder.addConstructorArgValue(expressionElementValue);
            return expressionDefBuilder.getRawBeanDefinition();
        }
        return null;
    }
}

