/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import com.rabbitmq.client.impl.nio.NioParams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitConnectionFactoryBean
extends AbstractFactoryBean<ConnectionFactory> {
    private static final String SUN_X509 = "SunX509";
    private static final String KEY_STORE = "keyStore";
    private static final String TRUST_STORE = "trustStore";
    private static final String KEY_STORE_PASS_PHRASE = "keyStore.passPhrase";
    private static final String TRUST_STORE_PASS_PHRASE = "trustStore.passPhrase";
    private static final String KEY_STORE_TYPE = "keyStore.type";
    private static final String TRUST_STORE_TYPE = "trustStore.type";
    private static final String DEFAULT_PROTOCOL;
    private static final String KEY_STORE_DEFAULT_TYPE = "PKCS12";
    private static final String TRUST_STORE_DEFAULT_TYPE = "JKS";
    protected final ConnectionFactory connectionFactory = new ConnectionFactory();
    private final Properties sslProperties = new Properties();
    private ResourceLoader resourceLoader = new PathMatchingResourcePatternResolver();
    private boolean useSSL;
    private Resource sslPropertiesLocation;
    private String keyStore;
    private String trustStore;
    private Resource keyStoreResource;
    private Resource trustStoreResource;
    private String keyStorePassphrase;
    private String trustStorePassphrase;
    private String keyStoreType;
    private String trustStoreType;
    private String sslAlgorithm = DEFAULT_PROTOCOL;
    private boolean sslAlgorithmSet;
    private SecureRandom secureRandom;
    private boolean skipServerCertificateValidation;
    private boolean enableHostnameVerification = true;
    private String keyStoreAlgorithm = "SunX509";
    private String trustStoreAlgorithm = "SunX509";

    public RabbitConnectionFactoryBean() {
        this.connectionFactory.setAutomaticRecoveryEnabled(false);
    }

    public boolean isSkipServerCertificateValidation() {
        return this.skipServerCertificateValidation;
    }

    public void setSkipServerCertificateValidation(boolean skipServerCertificateValidation) {
        this.skipServerCertificateValidation = skipServerCertificateValidation;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    protected boolean isUseSSL() {
        return this.useSSL;
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = sslAlgorithm;
        this.sslAlgorithmSet = true;
    }

    protected String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public void setSslPropertiesLocation(Resource sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    protected Resource getSslPropertiesLocation() {
        return this.sslPropertiesLocation;
    }

    protected String getKeyStore() {
        return this.keyStore == null ? this.sslProperties.getProperty(KEY_STORE) : this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    protected Resource getKeyStoreResource() {
        return this.keyStoreResource;
    }

    public void setKeyStoreResource(Resource keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    protected String getTrustStore() {
        return this.trustStore == null ? this.sslProperties.getProperty(TRUST_STORE) : this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    protected Resource getTrustStoreResource() {
        return this.trustStoreResource;
    }

    public void setTrustStoreResource(Resource trustStoreResource) {
        this.trustStoreResource = trustStoreResource;
    }

    protected String getKeyStorePassphrase() {
        return this.keyStorePassphrase == null ? this.sslProperties.getProperty(KEY_STORE_PASS_PHRASE) : this.keyStorePassphrase;
    }

    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    protected String getTrustStorePassphrase() {
        return this.trustStorePassphrase == null ? this.sslProperties.getProperty(TRUST_STORE_PASS_PHRASE) : this.trustStorePassphrase;
    }

    public void setTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }

    protected String getKeyStoreType() {
        if (this.keyStoreType == null && this.sslProperties.getProperty(KEY_STORE_TYPE) == null) {
            return KEY_STORE_DEFAULT_TYPE;
        }
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        return this.sslProperties.getProperty(KEY_STORE_TYPE);
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    protected String getTrustStoreType() {
        if (this.trustStoreType == null && this.sslProperties.getProperty(TRUST_STORE_TYPE) == null) {
            return TRUST_STORE_DEFAULT_TYPE;
        }
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        return this.sslProperties.getProperty(TRUST_STORE_TYPE);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    protected SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public void setHost(String host) {
        this.connectionFactory.setHost(host);
    }

    public void setPort(int port) {
        this.connectionFactory.setPort(port);
    }

    public void setUsername(String username) {
        this.connectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.connectionFactory.setPassword(password);
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.connectionFactory.setCredentialsProvider(provider);
    }

    public void setCredentialsRefreshService(CredentialsRefreshService service) {
        this.connectionFactory.setCredentialsRefreshService(service);
    }

    public void setVirtualHost(String virtualHost) {
        this.connectionFactory.setVirtualHost(virtualHost);
    }

    public void setUri(URI uri) {
        try {
            this.connectionFactory.setUri(uri);
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unable to set uri", e);
        }
    }

    public void setUri(String uriString) {
        try {
            this.connectionFactory.setUri(uriString);
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unable to set uri", e);
        }
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.connectionFactory.setRequestedChannelMax(requestedChannelMax);
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.connectionFactory.setRequestedFrameMax(requestedFrameMax);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionFactory.setConnectionTimeout(connectionTimeout);
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.connectionFactory.setRequestedHeartbeat(requestedHeartbeat);
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.connectionFactory.getClientProperties().putAll(clientProperties);
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.connectionFactory.setSaslConfig(saslConfig);
    }

    public void setSocketFactory(SocketFactory factory) {
        this.connectionFactory.setSocketFactory(factory);
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.connectionFactory.setSocketConfigurator(socketConfigurator);
    }

    public void setSharedExecutor(ExecutorService executor) {
        this.connectionFactory.setSharedExecutor(executor);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.connectionFactory.setThreadFactory(threadFactory);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.connectionFactory.setExceptionHandler(exceptionHandler);
    }

    public void setUseNio(boolean useNio) {
        if (useNio) {
            this.connectionFactory.useNio();
        } else {
            this.connectionFactory.useBlockingIo();
        }
    }

    public void setNioParams(NioParams nioParams) {
        this.connectionFactory.setNioParams(nioParams);
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.connectionFactory.setMetricsCollector(metricsCollector);
    }

    public void setAutomaticRecoveryEnabled(boolean automaticRecoveryEnabled) {
        this.connectionFactory.setAutomaticRecoveryEnabled(automaticRecoveryEnabled);
    }

    public void setTopologyRecoveryEnabled(boolean topologyRecoveryEnabled) {
        this.connectionFactory.setTopologyRecoveryEnabled(topologyRecoveryEnabled);
    }

    public void setChannelRpcTimeout(int channelRpcTimeout) {
        this.connectionFactory.setChannelRpcTimeout(channelRpcTimeout);
    }

    public void setEnableHostnameVerification(boolean enable) {
        this.enableHostnameVerification = enable;
    }

    public void setMaxInboundMessageBodySize(int maxInboundMessageBodySize) {
        this.connectionFactory.setMaxInboundMessageBodySize(maxInboundMessageBodySize);
    }

    protected String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    protected String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "'resourceLoader' cannot be null");
        this.resourceLoader = resourceLoader;
    }

    public ConnectionFactory getRabbitConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public void afterPropertiesSet() {
        try {
            super.afterPropertiesSet();
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public Class<?> getObjectType() {
        return ConnectionFactory.class;
    }

    @Override
    protected ConnectionFactory createInstance() {
        if (this.useSSL) {
            this.setUpSSL();
        }
        return this.connectionFactory;
    }

    protected void setUpSSL() {
        try {
            if (this.sslPropertiesLocation == null && this.keyStore == null && this.trustStore == null && this.keyStoreResource == null && this.trustStoreResource == null) {
                this.setupBasicSSL();
            } else {
                if (this.sslPropertiesLocation != null) {
                    this.sslProperties.load(this.sslPropertiesLocation.getInputStream());
                }
                Object[] keyManagers = this.configureKeyManagers();
                Object[] trustManagers = this.configureTrustManagers();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Initializing SSLContext with KM: " + Arrays.toString(keyManagers) + ", TM: " + Arrays.toString(trustManagers) + ", random: " + this.secureRandom);
                }
                SSLContext context = this.createSSLContext();
                context.init((KeyManager[])keyManagers, (TrustManager[])trustManagers, this.secureRandom);
                this.connectionFactory.useSslProtocol(context);
                if (this.enableHostnameVerification) {
                    this.connectionFactory.enableHostnameVerification();
                }
            }
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private void setupBasicSSL() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        if (this.skipServerCertificateValidation) {
            if (this.sslAlgorithmSet) {
                this.connectionFactory.useSslProtocol(this.sslAlgorithm);
            } else {
                this.connectionFactory.useSslProtocol();
            }
        } else {
            this.useDefaultTrustStoreMechanism();
        }
    }

    @Nullable
    protected KeyManager[] configureKeyManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        String keyStoreName = this.getKeyStore();
        String keyStorePassword = this.getKeyStorePassphrase();
        String storeType = this.getKeyStoreType();
        char[] keyPassphrase = null;
        if (keyStorePassword != null) {
            keyPassphrase = keyStorePassword.toCharArray();
        }
        KeyManager[] keyManagers = null;
        if (StringUtils.hasText(keyStoreName) || this.keyStoreResource != null) {
            Resource resource = this.keyStoreResource != null ? this.keyStoreResource : this.resourceLoader.getResource(keyStoreName);
            KeyStore ks = KeyStore.getInstance(storeType);
            try (InputStream inputStream = resource.getInputStream();){
                ks.load(inputStream, keyPassphrase);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
            kmf.init(ks, keyPassphrase);
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    @Nullable
    protected TrustManager[] configureTrustManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String trustStoreName = this.getTrustStore();
        String trustStorePassword = this.getTrustStorePassphrase();
        String storeType = this.getTrustStoreType();
        char[] trustPassphrase = null;
        if (trustStorePassword != null) {
            trustPassphrase = trustStorePassword.toCharArray();
        }
        TrustManager[] trustManagers = null;
        if (StringUtils.hasText(trustStoreName) || this.trustStoreResource != null) {
            Resource resource = this.trustStoreResource != null ? this.trustStoreResource : this.resourceLoader.getResource(trustStoreName);
            KeyStore tks = KeyStore.getInstance(storeType);
            try (InputStream inputStream = resource.getInputStream();){
                tks.load(inputStream, trustPassphrase);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
            tmf.init(tks);
            trustManagers = tmf.getTrustManagers();
        }
        return trustManagers;
    }

    protected SSLContext createSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance(this.sslAlgorithm);
    }

    private void useDefaultTrustStoreMechanism() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = SSLContext.getInstance(this.sslAlgorithm);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        this.connectionFactory.useSslProtocol(sslContext);
        if (this.enableHostnameVerification) {
            this.connectionFactory.enableHostnameVerification();
        }
    }

    static {
        String protocol = "TLSv1.1";
        try {
            String[] protocols;
            for (String prot : protocols = SSLContext.getDefault().getSupportedSSLParameters().getProtocols()) {
                if (!"TLSv1.2".equals(prot)) continue;
                protocol = "TLSv1.2";
                break;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        DEFAULT_PROTOCOL = protocol;
    }
}

