/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.transaction;

import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class RabbitTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private ConnectionFactory connectionFactory;

    public RabbitTransactionManager() {
        this.setTransactionSynchronization(2);
    }

    public RabbitTransactionManager(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "'connectionFactory' cannot be null");
        this.connectionFactory = connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.getConnectionFactory() != null, "Property 'connectionFactory' is required");
    }

    @Override
    public Object getResourceFactory() {
        return this.getConnectionFactory();
    }

    @Override
    protected Object doGetTransaction() {
        RabbitTransactionObject txObject = new RabbitTransactionObject();
        txObject.setResourceHolder((RabbitResourceHolder)TransactionSynchronizationManager.getResource(this.getConnectionFactory()));
        return txObject;
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        return txObject.getResourceHolder() != null;
    }

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("AMQP does not support an isolation level concept");
        }
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        RabbitResourceHolder resourceHolder = null;
        try {
            resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.getConnectionFactory(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created AMQP transaction on channel [" + resourceHolder.getChannel() + "]");
            }
            txObject.setResourceHolder(resourceHolder);
            txObject.getResourceHolder().setSynchronizedWithTransaction(true);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getResourceHolder().setTimeoutInSeconds(timeout);
            }
            TransactionSynchronizationManager.bindResource(this.getConnectionFactory(), txObject.getResourceHolder());
        }
        catch (AmqpException ex) {
            if (resourceHolder != null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
            }
            throw new CannotCreateTransactionException("Could not create AMQP transaction", ex);
        }
    }

    @Override
    protected Object doSuspend(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        txObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.getConnectionFactory());
    }

    @Override
    protected void doResume(Object transaction, Object suspendedResources) {
        RabbitResourceHolder conHolder = (RabbitResourceHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getConnectionFactory(), conHolder);
    }

    @Override
    protected void doCommit(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        RabbitResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.commitAll();
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        RabbitResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.rollbackAll();
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        txObject.getResourceHolder().setRollbackOnly();
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getConnectionFactory());
        txObject.getResourceHolder().closeAll();
        txObject.getResourceHolder().clear();
    }

    private static class RabbitTransactionObject
    implements SmartTransactionObject {
        private RabbitResourceHolder resourceHolder;

        RabbitTransactionObject() {
        }

        public void setResourceHolder(RabbitResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        public RabbitResourceHolder getResourceHolder() {
            return this.resourceHolder;
        }

        @Override
        public boolean isRollbackOnly() {
            return this.resourceHolder.isRollbackOnly();
        }

        @Override
        public void flush() {
        }
    }
}

