/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.interceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryCallback;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class MethodInvocationRetryCallback<T, E extends Throwable>
implements RetryCallback<T, E> {
    protected final MethodInvocation invocation;
    protected final String label;

    public MethodInvocationRetryCallback(MethodInvocation invocation, @Nullable String label) {
        this.invocation = invocation;
        this.label = StringUtils.hasText(label) ? label : ClassUtils.getQualifiedMethodName(invocation.getMethod());
    }

    public MethodInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

