/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        RedisEndpoint target = (RedisEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(RedisEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "channels": {
                target.getConfiguration().setChannels(RedisEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "command": {
                target.getConfiguration().setCommand(RedisEndpointConfigurer.property(camelContext, Command.class, value));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                target.getConfiguration().setConnectionFactory(RedisEndpointConfigurer.property(camelContext, RedisConnectionFactory.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(RedisEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(RedisEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(RedisEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "listenercontainer": 
            case "listenerContainer": {
                target.getConfiguration().setListenerContainer(RedisEndpointConfigurer.property(camelContext, RedisMessageListenerContainer.class, value));
                return true;
            }
            case "redistemplate": 
            case "redisTemplate": {
                target.getConfiguration().setRedisTemplate(RedisEndpointConfigurer.property(camelContext, RedisTemplate.class, value));
                return true;
            }
            case "serializer": {
                target.getConfiguration().setSerializer(RedisEndpointConfigurer.property(camelContext, RedisSerializer.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "channels": {
                return String.class;
            }
            case "command": {
                return Command.class;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return RedisConnectionFactory.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "listenercontainer": 
            case "listenerContainer": {
                return RedisMessageListenerContainer.class;
            }
            case "redistemplate": 
            case "redisTemplate": {
                return RedisTemplate.class;
            }
            case "serializer": {
                return RedisSerializer.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        RedisEndpoint target = (RedisEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "channels": {
                return target.getConfiguration().getChannels();
            }
            case "command": {
                return target.getConfiguration().getCommand();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return target.getConfiguration().getConnectionFactory();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "listenercontainer": 
            case "listenerContainer": {
                return target.getConfiguration().getListenerContainer();
            }
            case "redistemplate": 
            case "redisTemplate": {
                return target.getConfiguration().getRedisTemplate();
            }
            case "serializer": {
                return target.getConfiguration().getSerializer();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "redistemplate": 
            case "redisTemplate": {
                return Object.class;
            }
            case "serializer": {
                return Object.class;
            }
        }
        return null;
    }
}

