/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.SpelCriteria;
import org.springframework.data.keyvalue.core.SpelCriteriaAccessor;
import org.springframework.data.keyvalue.core.SpelSortAccessor;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class SpelQueryEngine
extends QueryEngine<KeyValueAdapter, SpelCriteria, Comparator<?>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public SpelQueryEngine() {
        this(new SpelSortAccessor(PARSER));
    }

    public SpelQueryEngine(SortAccessor<Comparator<?>> sortAccessor) {
        super(new SpelCriteriaAccessor(PARSER), sortAccessor);
    }

    @Override
    public Collection<?> execute(@Nullable SpelCriteria criteria, @Nullable Comparator<?> sort, long offset, int rows, String keyspace) {
        return this.sortAndFilterMatchingRange(this.getRequiredAdapter().getAllOf(keyspace), criteria, sort, offset, rows);
    }

    @Override
    public long count(@Nullable SpelCriteria criteria, String keyspace) {
        return SpelQueryEngine.filterMatchingRange(IterableConverter.toList(this.getRequiredAdapter().getAllOf(keyspace)), criteria, -1L, -1).size();
    }

    private List<?> sortAndFilterMatchingRange(Iterable<?> source, @Nullable SpelCriteria criteria, @Nullable Comparator sort, long offset, int rows) {
        List<?> tmp = IterableConverter.toList(source);
        if (sort != null) {
            tmp.sort(sort);
        }
        return SpelQueryEngine.filterMatchingRange(tmp, criteria, offset, rows);
    }

    private static <S> List<S> filterMatchingRange(List<S> source, @Nullable SpelCriteria criteria, long offset, int rows) {
        Stream<Object> stream = source.stream();
        if (criteria != null) {
            stream = stream.filter(it -> SpelQueryEngine.evaluateExpression(criteria, it));
        }
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (rows > 0) {
            stream = stream.limit(rows);
        }
        return stream.collect(Collectors.toList());
    }

    private static boolean evaluateExpression(SpelCriteria criteria, Object candidate) {
        try {
            return criteria.getExpression().getValue(criteria.getContext(), candidate, Boolean.class);
        }
        catch (SpelEvaluationException e) {
            criteria.getContext().setVariable("it", candidate);
            return criteria.getExpression().getValue(criteria.getContext()) == null ? false : criteria.getExpression().getValue(criteria.getContext(), Boolean.class);
        }
    }
}

