/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.SpelPropertyComparator;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpelSortAccessor
implements SortAccessor<Comparator<?>> {
    private final SpelExpressionParser parser;

    public SpelSortAccessor(SpelExpressionParser parser) {
        Assert.notNull((Object)parser, "SpelExpressionParser must not be null");
        this.parser = parser;
    }

    @Override
    public Comparator<?> resolve(KeyValueQuery<?> query) {
        if (query.getSort().isUnsorted()) {
            return null;
        }
        Optional<Object> comparator = Optional.empty();
        for (Sort.Order order : query.getSort()) {
            SpelPropertyComparator spelSort = new SpelPropertyComparator(order.getProperty(), this.parser);
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                spelSort.desc();
                if (!Sort.NullHandling.NATIVE.equals((Object)order.getNullHandling())) {
                    SpelPropertyComparator spelPropertyComparator = spelSort = Sort.NullHandling.NULLS_FIRST.equals((Object)order.getNullHandling()) ? spelSort.nullsFirst() : spelSort.nullsLast();
                }
            }
            if (!comparator.isPresent()) {
                comparator = Optional.of(spelSort);
                continue;
            }
            SpelPropertyComparator spelSortToUse = spelSort;
            comparator = comparator.map(it -> it.thenComparing(spelSortToUse));
        }
        return (Comparator)comparator.orElseThrow(() -> new IllegalStateException("No sort definitions have been added to this CompoundComparator to compare"));
    }
}

