/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class KeyValueRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private KeyValueOperations operations;
    @Nullable
    private Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    @Nullable
    private Class<? extends RepositoryQuery> repositoryQueryType;

    public KeyValueRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setKeyValueOperations(KeyValueOperations operations) {
        Assert.notNull((Object)operations, "KeyValueOperations must not be null");
        this.operations = operations;
    }

    @Override
    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    public void setQueryCreator(Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull(queryCreator, "Query creator type must not be null");
        this.queryCreator = queryCreator;
    }

    public void setQueryType(Class<? extends RepositoryQuery> repositoryQueryType) {
        Assert.notNull(repositoryQueryType, "Query creator type must not be null");
        this.repositoryQueryType = repositoryQueryType;
    }

    @Override
    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.createRepositoryFactory(this.operations, this.queryCreator, this.repositoryQueryType);
    }

    protected KeyValueRepositoryFactory createRepositoryFactory(KeyValueOperations operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        return new KeyValueRepositoryFactory(operations, queryCreator, repositoryQueryType);
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.operations, "KeyValueOperations must not be null");
        Assert.notNull(this.queryCreator, "Query creator type must not be null");
        Assert.notNull(this.repositoryQueryType, "RepositoryQueryType type type must not be null");
        super.afterPropertiesSet();
    }
}

