/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.KotlinDefaultMask;
import org.springframework.data.mapping.model.KotlinValueUtils;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;

class KotlinInstantiationDelegate {
    private final KFunction<?> constructor;
    private final List<KParameter> kParameters;
    private final Map<KParameter, Integer> indexByKParameter;
    private final List<Function<Object, Object>> wrappers = new ArrayList<Function<Object, Object>>();
    private final Constructor<?> constructorToInvoke;
    private final boolean hasDefaultConstructorMarker;

    public KotlinInstantiationDelegate(PreferredConstructor<?, ?> preferredConstructor, Constructor<?> constructorToInvoke) {
        KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction(preferredConstructor.getConstructor());
        if (kotlinConstructor == null) {
            throw new IllegalArgumentException("No corresponding Kotlin constructor found for " + preferredConstructor.getConstructor());
        }
        this.constructor = kotlinConstructor;
        this.kParameters = kotlinConstructor.getParameters();
        this.indexByKParameter = new IdentityHashMap<KParameter, Integer>();
        for (int i = 0; i < this.kParameters.size(); ++i) {
            this.indexByKParameter.put(this.kParameters.get(i), i);
        }
        this.constructorToInvoke = constructorToInvoke;
        this.hasDefaultConstructorMarker = KotlinInstantiationDelegate.hasDefaultConstructorMarker(constructorToInvoke.getParameters());
        for (KParameter kParameter : this.kParameters) {
            KotlinValueUtils.ValueBoxing valueBoxing = KotlinValueUtils.getConstructorValueHierarchy(kParameter);
            this.wrappers.add(valueBoxing::wrap);
        }
    }

    static boolean hasDefaultConstructorMarker(java.lang.reflect.Parameter[] parameters) {
        return parameters.length > 0 && parameters[parameters.length - 1].getType().getName().equals("kotlin.jvm.internal.DefaultConstructorMarker");
    }

    public int getRequiredParameterCount() {
        return this.hasDefaultConstructorMarker ? this.constructorToInvoke.getParameterCount() : this.constructorToInvoke.getParameterCount() + KotlinDefaultMask.getMaskCount(this.constructorToInvoke.getParameterCount()) + 1;
    }

    public <P extends PersistentProperty<P>> Object[] extractInvocationArguments(Object[] params, @Nullable InstanceCreatorMetadata<P> entityCreator, ParameterValueProvider<P> provider) {
        if (entityCreator == null) {
            throw new IllegalArgumentException("EntityCreator must not be null");
        }
        int userParameterCount = this.kParameters.size();
        List parameters = entityCreator.getParameters();
        for (int i = 0; i < userParameterCount; ++i) {
            Parameter<Object, P> parameter = parameters.get(i);
            params[i] = provider.getParameterValue(parameter);
        }
        KotlinDefaultMask defaultMask = KotlinDefaultMask.forConstructor(this.constructor, it -> {
            int index = this.indexByKParameter.get(it);
            Parameter parameter = (Parameter)parameters.get(index);
            Class type = parameter.getType().getType();
            if (it.isOptional() && params[index] == null) {
                if (type.isPrimitive()) {
                    params[index] = ReflectionUtils.getPrimitiveDefault(type);
                }
                return false;
            }
            return true;
        });
        for (int i = 0; i < userParameterCount; ++i) {
            params[i] = this.wrappers.get(i).apply(params[i]);
        }
        int[] defaulting = defaultMask.getDefaulting();
        for (int i = 0; i < defaulting.length; ++i) {
            params[userParameterCount + i] = defaulting[i];
        }
        return params;
    }

    @Nullable
    public static PreferredConstructor<?, ?> resolveKotlinJvmConstructor(PreferredConstructor<?, ?> preferredConstructor) {
        Constructor<?> hit = KotlinInstantiationDelegate.doResolveKotlinConstructor(preferredConstructor.getConstructor());
        if (hit == preferredConstructor.getConstructor()) {
            return preferredConstructor;
        }
        if (hit != null) {
            return new PreferredConstructor(hit, preferredConstructor.getParameters().toArray(new Parameter[0]));
        }
        return null;
    }

    @Nullable
    private static Constructor<?> doResolveKotlinConstructor(Constructor<?> detectedConstructor) {
        Class<?> entityType = detectedConstructor.getDeclaringClass();
        Constructor<?> hit = null;
        KFunction kotlinFunction = ReflectJvmMapping.getKotlinFunction(detectedConstructor);
        for (Constructor<?> candidate : entityType.getDeclaredConstructors()) {
            int userParameterCount;
            if (!candidate.isSynthetic()) continue;
            java.lang.reflect.Parameter[] detectedConstructorParameters = detectedConstructor.getParameters();
            java.lang.reflect.Parameter[] candidateParameters = candidate.getParameters();
            if (!KotlinInstantiationDelegate.hasDefaultConstructorMarker(detectedConstructorParameters)) {
                int syntheticParameters = KotlinDefaultMask.getMaskCount(detectedConstructor.getParameterCount()) + 1;
                if (detectedConstructor.getParameterCount() + syntheticParameters != candidate.getParameterCount()) {
                    continue;
                }
            } else {
                int optionalParameterCount = (int)kotlinFunction.getParameters().stream().filter(it -> it.isOptional()).count();
                int syntheticParameters = KotlinDefaultMask.getExactMaskCount(optionalParameterCount);
                if (detectedConstructor.getParameterCount() + syntheticParameters != candidate.getParameterCount()) continue;
            }
            if (!KotlinInstantiationDelegate.hasDefaultConstructorMarker(candidateParameters)) continue;
            int n = userParameterCount = kotlinFunction != null ? kotlinFunction.getParameters().size() : detectedConstructor.getParameterCount();
            if (!KotlinInstantiationDelegate.parametersMatch(detectedConstructorParameters, candidateParameters, userParameterCount)) continue;
            hit = candidate;
        }
        return hit;
    }

    private static boolean parametersMatch(java.lang.reflect.Parameter[] constructorParameters, java.lang.reflect.Parameter[] candidateParameters, int userParameterCount) {
        return IntStream.range(0, userParameterCount).allMatch(i -> KotlinInstantiationDelegate.parametersMatch(constructorParameters[i], candidateParameters[i]));
    }

    static boolean parametersMatch(java.lang.reflect.Parameter constructorParameter, java.lang.reflect.Parameter candidateParameter) {
        if (constructorParameter.getType().equals(candidateParameter.getType())) {
            return true;
        }
        Class<?> componentOrWrapperType = KotlinValueUtils.getConstructorValueHierarchy(candidateParameter.getType()).getActualType();
        return constructorParameter.getType().equals(componentOrWrapperType);
    }
}

