/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BitFieldSubCommands
implements Iterable<BitFieldSubCommand> {
    private final List<BitFieldSubCommand> subCommands;

    private BitFieldSubCommands(List<BitFieldSubCommand> subCommands) {
        this.subCommands = new ArrayList<BitFieldSubCommand>(subCommands);
    }

    private BitFieldSubCommands(List<BitFieldSubCommand> subCommands, BitFieldSubCommand subCommand) {
        this(subCommands);
        Assert.notNull((Object)subCommand, "SubCommand must not be null");
        this.subCommands.add(subCommand);
    }

    public static BitFieldSubCommands create() {
        return new BitFieldSubCommands(Collections.emptyList());
    }

    public static BitFieldSubCommands create(BitFieldSubCommand ... subCommands) {
        Assert.notNull((Object)subCommands, "Subcommands must not be null");
        return new BitFieldSubCommands(Arrays.asList(subCommands));
    }

    public BitFieldGetBuilder get(BitFieldType type) {
        return new BitFieldGetBuilder(this).forType(type);
    }

    protected BitFieldSubCommands get(BitFieldGet get) {
        return new BitFieldSubCommands(this.subCommands, get);
    }

    public BitFieldSetBuilder set(BitFieldType type) {
        return new BitFieldSetBuilder(this).forType(type);
    }

    protected BitFieldSubCommands set(BitFieldSet set) {
        return new BitFieldSubCommands(this.subCommands, set);
    }

    public BitFieldIncrByBuilder incr(BitFieldType type) {
        return new BitFieldIncrByBuilder(this).forType(type);
    }

    protected BitFieldSubCommands incr(BitFieldIncrBy incrBy) {
        return new BitFieldSubCommands(this.subCommands, incrBy);
    }

    public List<BitFieldSubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public Iterator<BitFieldSubCommand> iterator() {
        return this.subCommands.iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitFieldSubCommands)) {
            return false;
        }
        BitFieldSubCommands that = (BitFieldSubCommands)o;
        return ObjectUtils.nullSafeEquals(this.subCommands, that.subCommands);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.subCommands);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [subCommands=").append(this.subCommands);
        sb.append(']');
        return sb.toString();
    }

    public static class BitFieldGetBuilder {
        private BitFieldSubCommands ref;
        BitFieldGet get = new BitFieldGet();

        private BitFieldGetBuilder(BitFieldSubCommands ref) {
            this.ref = ref;
        }

        public BitFieldGetBuilder forType(BitFieldType type) {
            this.get.type = type;
            return this;
        }

        public BitFieldSubCommands valueAt(long offset) {
            return this.valueAt(Offset.offset(offset));
        }

        public BitFieldSubCommands valueAt(Offset offset) {
            Assert.notNull((Object)offset, "Offset must not be null");
            this.get.offset = offset;
            return this.ref.get(this.get);
        }
    }

    public static class BitFieldType {
        public static final BitFieldType INT_8 = new BitFieldType(true, 8);
        public static final BitFieldType INT_16 = new BitFieldType(true, 16);
        public static final BitFieldType INT_32 = new BitFieldType(true, 32);
        public static final BitFieldType INT_64 = new BitFieldType(true, 64);
        public static final BitFieldType UINT_8 = new BitFieldType(false, 8);
        public static final BitFieldType UINT_16 = new BitFieldType(false, 16);
        public static final BitFieldType UINT_32 = new BitFieldType(false, 32);
        public static final BitFieldType UINT_64 = new BitFieldType(false, 64);
        private final boolean signed;
        private final int bits;

        private BitFieldType(boolean signed, Integer bits) {
            this.signed = signed;
            this.bits = bits;
        }

        public static BitFieldType signed(int bits) {
            return new BitFieldType(true, bits);
        }

        public static BitFieldType unsigned(int bits) {
            return new BitFieldType(false, bits);
        }

        public boolean isSigned() {
            return this.signed;
        }

        public int getBits() {
            return this.bits;
        }

        public String asString() {
            return (this.isSigned() ? "i" : "u") + this.getBits();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitFieldType)) {
                return false;
            }
            BitFieldType that = (BitFieldType)o;
            if (this.signed != that.signed) {
                return false;
            }
            return this.bits == that.bits;
        }

        public int hashCode() {
            int result = this.signed ? 1 : 0;
            result = 31 * result + this.bits;
            return result;
        }

        public String toString() {
            return this.asString();
        }
    }

    public static interface BitFieldSubCommand {
        public String getCommand();

        public BitFieldType getType();

        public Offset getOffset();
    }

    public static class BitFieldSetBuilder {
        private BitFieldSubCommands ref;
        BitFieldSet set = new BitFieldSet();

        private BitFieldSetBuilder(BitFieldSubCommands ref) {
            this.ref = ref;
        }

        public BitFieldSetBuilder forType(BitFieldType type) {
            this.set.type = type;
            return this;
        }

        public BitFieldSetBuilder valueAt(long offset) {
            return this.valueAt(Offset.offset(offset));
        }

        public BitFieldSetBuilder valueAt(Offset offset) {
            Assert.notNull((Object)offset, "Offset must not be null");
            this.set.offset = offset;
            return this;
        }

        public BitFieldSubCommands to(long value) {
            this.set.value = value;
            return this.ref.set(this.set);
        }
    }

    public class BitFieldIncrByBuilder {
        private BitFieldSubCommands ref;
        BitFieldIncrBy incrBy = new BitFieldIncrBy();

        private BitFieldIncrByBuilder(BitFieldSubCommands ref) {
            this.ref = ref;
        }

        public BitFieldIncrByBuilder forType(BitFieldType type) {
            this.incrBy.type = type;
            return this;
        }

        public BitFieldIncrByBuilder valueAt(long offset) {
            return this.valueAt(Offset.offset(offset));
        }

        public BitFieldIncrByBuilder valueAt(Offset offset) {
            Assert.notNull((Object)offset, "Offset must not be null");
            this.incrBy.offset = offset;
            return this;
        }

        public BitFieldIncrByBuilder overflow(BitFieldIncrBy.Overflow overflow) {
            this.incrBy.overflow = overflow;
            return this;
        }

        public BitFieldSubCommands by(long value) {
            this.incrBy.value = value;
            return this.ref.incr(this.incrBy);
        }
    }

    public static class BitFieldIncrBy
    extends AbstractBitFieldSubCommand {
        private long value;
        @Nullable
        private Overflow overflow;

        public static BitFieldIncrBy create(BitFieldType type, Offset offset, long value) {
            return BitFieldIncrBy.create(type, offset, value, null);
        }

        public static BitFieldIncrBy create(BitFieldType type, Offset offset, long value, @Nullable Overflow overflow) {
            Assert.notNull((Object)type, "BitFieldType must not be null");
            Assert.notNull((Object)offset, "Offset must not be null");
            BitFieldIncrBy instance = new BitFieldIncrBy();
            instance.type = type;
            instance.offset = offset;
            instance.value = value;
            instance.overflow = overflow;
            return instance;
        }

        @Override
        public String getCommand() {
            return "INCRBY";
        }

        public long getValue() {
            return this.value;
        }

        @Nullable
        public Overflow getOverflow() {
            return this.overflow;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitFieldIncrBy)) {
                return false;
            }
            BitFieldIncrBy that = (BitFieldIncrBy)o;
            if (this.value != that.value) {
                return false;
            }
            return this.overflow == that.overflow;
        }

        @Override
        public int hashCode() {
            int result = (int)(this.value ^ this.value >>> 32);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.overflow);
            return result;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [type=").append(this.type);
            sb.append(", offset=").append(this.offset);
            sb.append(", value=").append(this.value);
            sb.append(", overflow=").append((Object)this.overflow);
            sb.append(']');
            return sb.toString();
        }

        public static enum Overflow {
            SAT,
            FAIL,
            WRAP;

        }
    }

    public static class BitFieldGet
    extends AbstractBitFieldSubCommand {
        public static BitFieldGet create(BitFieldType type, Offset offset) {
            Assert.notNull((Object)type, "BitFieldType must not be null");
            Assert.notNull((Object)offset, "Offset must not be null");
            BitFieldGet instance = new BitFieldGet();
            instance.type = type;
            instance.offset = offset;
            return instance;
        }

        @Override
        public String getCommand() {
            return "GET";
        }
    }

    public static class BitFieldSet
    extends AbstractBitFieldSubCommand {
        private long value;

        public static BitFieldSet create(BitFieldType type, Offset offset, long value) {
            Assert.notNull((Object)type, "BitFieldType must not be null");
            Assert.notNull((Object)offset, "Offset must not be null");
            BitFieldSet instance = new BitFieldSet();
            instance.type = type;
            instance.offset = offset;
            instance.value = value;
            return instance;
        }

        @Override
        public String getCommand() {
            return "SET";
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitFieldSet)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BitFieldSet that = (BitFieldSet)o;
            return this.value == that.value;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [type=").append(this.type);
            sb.append(", offset=").append(this.offset);
            sb.append(", value=").append(this.value);
            sb.append(']');
            return sb.toString();
        }
    }

    public static abstract class AbstractBitFieldSubCommand
    implements BitFieldSubCommand {
        BitFieldType type;
        Offset offset;

        @Override
        public BitFieldType getType() {
            return this.type;
        }

        @Override
        public Offset getOffset() {
            return this.offset;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractBitFieldSubCommand)) {
                return false;
            }
            AbstractBitFieldSubCommand that = (AbstractBitFieldSubCommand)o;
            if (!ObjectUtils.nullSafeEquals(this.getClass(), that.getClass())) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.type, that.type)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.offset, that.offset);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.type);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.offset);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [type=").append(this.type);
            sb.append(", offset=").append(this.offset);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class Offset {
        private final long offset;
        private final boolean zeroBased;

        private Offset(long offset, boolean zeroBased) {
            this.offset = offset;
            this.zeroBased = zeroBased;
        }

        public static Offset offset(long offset) {
            return new Offset(offset, true);
        }

        public Offset multipliedByTypeLength() {
            return new Offset(this.offset, false);
        }

        public boolean isZeroBased() {
            return this.zeroBased;
        }

        public long getValue() {
            return this.offset;
        }

        public String asString() {
            return (this.isZeroBased() ? "" : "#") + this.getValue();
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Offset)) {
                return false;
            }
            Offset that = (Offset)o;
            if (this.offset != that.offset) {
                return false;
            }
            return this.zeroBased == that.zeroBased;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (this.zeroBased ? 1 : 0);
            return result;
        }
    }
}

