/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;

public interface RedisStringCommands {
    @Nullable
    public byte[] get(byte[] var1);

    @Nullable
    public byte[] getDel(byte[] var1);

    @Nullable
    public byte[] getEx(byte[] var1, Expiration var2);

    @Nullable
    public byte[] getSet(byte[] var1, byte[] var2);

    @Nullable
    public List<byte[]> mGet(byte[] ... var1);

    @Nullable
    public Boolean set(byte[] var1, byte[] var2);

    @Nullable
    public Boolean set(byte[] var1, byte[] var2, Expiration var3, SetOption var4);

    @Nullable
    public Boolean setNX(byte[] var1, byte[] var2);

    @Nullable
    public Boolean setEx(byte[] var1, long var2, byte[] var4);

    @Nullable
    public Boolean pSetEx(byte[] var1, long var2, byte[] var4);

    @Nullable
    public Boolean mSet(Map<byte[], byte[]> var1);

    @Nullable
    public Boolean mSetNX(Map<byte[], byte[]> var1);

    @Nullable
    public Long incr(byte[] var1);

    @Nullable
    public Long incrBy(byte[] var1, long var2);

    @Nullable
    public Double incrBy(byte[] var1, double var2);

    @Nullable
    public Long decr(byte[] var1);

    @Nullable
    public Long decrBy(byte[] var1, long var2);

    @Nullable
    public Long append(byte[] var1, byte[] var2);

    @Nullable
    public byte[] getRange(byte[] var1, long var2, long var4);

    public void setRange(byte[] var1, byte[] var2, long var3);

    @Nullable
    public Boolean getBit(byte[] var1, long var2);

    @Nullable
    public Boolean setBit(byte[] var1, long var2, boolean var4);

    @Nullable
    public Long bitCount(byte[] var1);

    @Nullable
    public Long bitCount(byte[] var1, long var2, long var4);

    @Nullable
    public List<Long> bitField(byte[] var1, BitFieldSubCommands var2);

    @Nullable
    public Long bitOp(BitOperation var1, byte[] var2, byte[] ... var3);

    @Nullable
    default public Long bitPos(byte[] key, boolean bit) {
        return this.bitPos(key, bit, Range.unbounded());
    }

    @Nullable
    public Long bitPos(byte[] var1, boolean var2, Range<Long> var3);

    @Nullable
    public Long strLen(byte[] var1);

    public static enum SetOption {
        UPSERT,
        SET_IF_ABSENT,
        SET_IF_PRESENT;


        public static SetOption upsert() {
            return UPSERT;
        }

        public static SetOption ifPresent() {
            return SET_IF_PRESENT;
        }

        public static SetOption ifAbsent() {
            return SET_IF_ABSENT;
        }
    }

    public static enum BitOperation {
        AND,
        OR,
        XOR,
        NOT;

    }
}

