/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

class JedisClusterKeyCommands
implements RedisKeyCommands {
    private final JedisClusterConnection connection;

    JedisClusterKeyCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean copy(byte[] sourceKey, byte[] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, "source key must not be null");
        Assert.notNull((Object)targetKey, "target key must not be null");
        return this.connection.getCluster().copy(sourceKey, targetKey, replace);
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().del(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.del(key), Arrays.asList(keys)).resultsAsList().size();
    }

    @Override
    @Nullable
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        return this.connection.execute("UNLINK", Arrays.asList(keys), Collections.emptyList()).stream().mapToLong(val -> val).sum();
    }

    @Override
    public DataType type(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toDataType(this.connection.getCluster().type(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        return this.connection.execute("TOUCH", Arrays.asList(keys), Collections.emptyList()).stream().mapToLong(val -> val).sum();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, "Pattern must not be null");
        List keysPerNode = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(client -> client.keys(pattern)).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (Set keySet : keysPerNode) {
            keys.addAll(keySet);
        }
        return keys;
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        Assert.notNull((Object)node, "RedisClusterNode must not be null");
        Assert.notNull((Object)pattern, "Pattern must not be null");
        return (Set)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.keys(pattern), node).getValue();
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        throw new InvalidDataAccessApiUsageException("Scan is not supported across multiple nodes within a cluster");
    }

    Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        Assert.notNull((Object)node, "RedisClusterNode must not be null");
        Assert.notNull((Object)options, "Options must not be null");
        return (Cursor)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> new ScanCursor<byte[]>(0L, options){

            @Override
            protected ScanIteration<byte[]> doScan(Cursor.CursorId cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult<String> result = client.scan(cursorId.getCursorId(), params);
                return new ScanIteration<byte[]>(Cursor.CursorId.of(result.getCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }
        }.open(), node).getValue();
    }

    @Override
    public byte[] randomKey() {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>(this.connection.getTopologyProvider().getTopology().getActiveMasterNodes());
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    public byte[] randomKey(RedisClusterNode node) {
        Assert.notNull((Object)node, "RedisClusterNode must not be null");
        return (byte[])this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.randomBinaryKey(), node).getValue();
    }

    @Override
    public void rename(byte[] oldKey, byte[] newKey) {
        Assert.notNull((Object)oldKey, "Old key must not be null");
        Assert.notNull((Object)newKey, "New key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldKey, newKey)) {
            try {
                this.connection.getCluster().rename(oldKey, newKey);
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(oldKey);
        if (value != null && value.length > 0) {
            this.restore(newKey, 0L, value, true);
            this.del(new byte[][]{oldKey});
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, "Source key must not be null");
        Assert.notNull((Object)targetKey, "Target key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            try {
                return JedisConverters.toBoolean(this.connection.getCluster().renamenx(sourceKey, targetKey));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0 && !this.exists(targetKey).booleanValue()) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().expire(key, seconds));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().pexpire(key, millis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().expireAt(key, unixTime));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().pexpireAt(key, unixTimeInMillis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().persist(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new InvalidDataAccessApiUsageException("Cluster mode does not allow moving keys");
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return this.connection.getCluster().ttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return Converters.secondsToTimeUnit(this.connection.getCluster().ttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return this.connection.getCluster().pttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return Converters.millisecondsToTimeUnit(this.connection.getCluster().pttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return this.connection.getCluster().dump(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)serializedValue, "Serialized value must not be null");
        RestoreParams restoreParams = RestoreParams.restoreParams();
        if (replace) {
            restoreParams = restoreParams.replace();
        }
        try {
            this.connection.getCluster().restore(key, ttlInMillis, serializedValue, restoreParams);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return this.connection.getCluster().sort(key, JedisConverters.toSortingParams(params));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Assert.notNull((Object)key, "Key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            try {
                return this.connection.getCluster().sort(key, JedisConverters.toSortingParams(params), storeKey);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<byte[]> sorted = this.sort(key, params);
        byte[][] arr = new byte[sorted.size()][];
        this.connection.keyCommands().unlink(new byte[][]{storeKey});
        this.connection.listCommands().lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
        return sorted.size();
    }

    @Override
    @Nullable
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().exists(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand(Jedis::exists, Arrays.asList(keys)).resultsAsList().stream().mapToLong(val -> ObjectUtils.nullSafeEquals(val, Boolean.TRUE) ? 1L : 0L).sum();
    }

    @Override
    @Nullable
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return JedisConverters.toEncoding(this.connection.getCluster().objectEncoding(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return Converters.secondsToDuration(this.connection.getCluster().objectIdletime(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        try {
            return this.connection.getCluster().objectRefcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

