/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveNumberCommands
implements ReactiveNumberCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveNumberCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> incr(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.incr((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.IncrByCommand<T>, T>> incrBy(Publisher<ReactiveNumberCommands.IncrByCommand<T>> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValue(), "Value for INCRBY must not be null");
            Object incrBy = command.getValue();
            Mono result = incrBy instanceof Double || incrBy instanceof Float ? cmd.incrbyfloat((Object)command.getKey(), ((Number)incrBy).doubleValue()) : cmd.incrby((Object)command.getKey(), ((Number)incrBy).longValue());
            return result.map(val -> NumberUtils.convertNumberToTargetClass(val, incrBy.getClass())).map(res -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.IncrByCommand, Number>((ReactiveNumberCommands.IncrByCommand)command, (Number)res));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> decr(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.decr((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.DecrByCommand<T>, T>> decrBy(Publisher<ReactiveNumberCommands.DecrByCommand<T>> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValue(), "Value for DECRBY must not be null");
            Object decrBy = command.getValue();
            Mono result = null;
            result = decrBy instanceof Double || decrBy instanceof Float ? cmd.incrbyfloat((Object)command.getKey(), ((Number)decrBy).doubleValue() * -1.0) : cmd.decrby((Object)command.getKey(), ((Number)decrBy).longValue());
            return result.map(val -> NumberUtils.convertNumberToTargetClass(val, decrBy.getClass())).map(res -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.DecrByCommand, Number>((ReactiveNumberCommands.DecrByCommand)command, (Number)res));
        }));
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.HIncrByCommand<T>, T>> hIncrBy(Publisher<ReactiveNumberCommands.HIncrByCommand<T>> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValue(), "Value must not be null");
            Object incrBy = command.getValue();
            Mono result = null;
            result = incrBy instanceof Double || incrBy instanceof Float ? cmd.hincrbyfloat((Object)command.getKey(), (Object)command.getField(), ((Number)incrBy).doubleValue()) : cmd.hincrby((Object)command.getKey(), (Object)command.getField(), ((Number)incrBy).longValue());
            return result.map(val -> NumberUtils.convertNumberToTargetClass(val, incrBy.getClass())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.HIncrByCommand, Number>((ReactiveNumberCommands.HIncrByCommand)command, (Number)value));
        }));
    }
}

