/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.SpelSortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.util.ByteArrayWrapper;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

class RedisQueryEngine
extends QueryEngine<RedisKeyValueAdapter, RedisOperationChain, Comparator<?>> {
    RedisQueryEngine() {
        this(new RedisCriteriaAccessor(), new SpelSortAccessor(new SpelExpressionParser()));
    }

    private RedisQueryEngine(CriteriaAccessor<RedisOperationChain> criteriaAccessor, @Nullable SortAccessor<Comparator<?>> sortAccessor) {
        super(criteriaAccessor, sortAccessor);
    }

    @Override
    public <T> List<T> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace, Class<T> type) {
        List<T> result = this.doFind(criteria, offset, rows, keyspace, type);
        if (sort != null) {
            result.sort(sort);
        }
        return result;
    }

    private <T> List<T> doFind(RedisOperationChain criteria, long offset, int rows, String keyspace, Class<T> type) {
        if (criteria == null || CollectionUtils.isEmpty(criteria.getOrSismember()) && CollectionUtils.isEmpty(criteria.getSismember()) && criteria.getNear() == null) {
            return ((RedisKeyValueAdapter)this.getRequiredAdapter()).getAllOf(keyspace, type, offset, rows);
        }
        RedisCallback<Map> callback = connection -> {
            List<byte[]> keys = this.findKeys(criteria, rows, keyspace, type, connection);
            byte[] keyspaceBin = ((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().getConversionService().convert((Object)(keyspace + ":"), byte[].class);
            LinkedHashMap<byte[], Map<byte[], byte[]>> rawData = new LinkedHashMap<byte[], Map<byte[], byte[]>>();
            if (keys.isEmpty() || (long)keys.size() < offset) {
                return Collections.emptyMap();
            }
            int offsetToUse = Math.max(0, (int)offset);
            if (rows > 0) {
                keys = keys.subList(Math.max(0, offsetToUse), Math.min(offsetToUse + rows, keys.size()));
            }
            for (byte[] id : keys) {
                byte[] singleKey = ByteUtils.concat(keyspaceBin, id);
                rawData.put(id, connection.hGetAll(singleKey));
            }
            return rawData;
        };
        Map raw = ((RedisKeyValueAdapter)this.getRequiredAdapter()).execute(callback);
        ArrayList<T> result = new ArrayList<T>(raw.size());
        for (Map.Entry entry : raw.entrySet()) {
            if (CollectionUtils.isEmpty((Map)entry.getValue())) continue;
            RedisData data = new RedisData((Map)entry.getValue());
            data.setId(((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().getConversionService().convert(entry.getKey(), String.class));
            data.setKeyspace(keyspace);
            T converted = ((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().read(type, data);
            result.add(converted);
        }
        return result;
    }

    private List<byte[]> findKeys(RedisOperationChain criteria, int rows, String keyspace, Class<?> domainType, RedisConnection connection) {
        KeySelector keySelector;
        ArrayList<byte[]> allKeys = new ArrayList<byte[]>();
        if (!criteria.getSismember().isEmpty()) {
            Set<RedisOperationChain.PathAndValue> sismember = criteria.getSismember();
            if (sismember.size() == 1) {
                KeySelector keySelector2 = KeySelector.of(((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter(), sismember, domainType);
                if (!keySelector2.setValueLookup().isEmpty()) {
                    allKeys.addAll(connection.sInter(this.keys(keyspace + ":", keySelector2.setValueLookup())));
                }
                allKeys.addAll(keySelector2.keys());
            } else {
                allKeys.addAll(connection.sInter(this.keys(keyspace + ":", sismember)));
            }
        }
        if (!(keySelector = KeySelector.of(((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter(), criteria.getOrSismember(), domainType)).setValueLookup().isEmpty()) {
            allKeys.addAll(connection.sUnion(this.keys(keyspace + ":", criteria.getOrSismember())));
        }
        allKeys.addAll(keySelector.keys());
        if (criteria.getNear() != null) {
            RedisGeoCommands.GeoRadiusCommandArgs limit = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
            if (rows > 0) {
                limit = limit.limit(rows);
            }
            GeoResults<RedisGeoCommands.GeoLocation<byte[]>> x = connection.geoRadius(this.geoKey(keyspace + ":", criteria.getNear()), new Circle(criteria.getNear().getPoint(), criteria.getNear().getDistance()), limit);
            for (GeoResult<RedisGeoCommands.GeoLocation<byte[]>> geoResult : x) {
                allKeys.add((byte[])geoResult.getContent().getName());
            }
        }
        LinkedHashSet unique = new LinkedHashSet(allKeys.size());
        allKeys.forEach(key -> unique.add(new ByteArrayWrapper((byte[])key)));
        ArrayList<byte[]> uniqueKeys = new ArrayList<byte[]>(unique.size());
        unique.forEach(key -> uniqueKeys.add(key.getArray()));
        return uniqueKeys;
    }

    @Override
    public List<?> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace) {
        return this.execute(criteria, sort, offset, rows, keyspace, Object.class);
    }

    @Override
    public long count(RedisOperationChain criteria, String keyspace) {
        if (criteria == null || criteria.isEmpty()) {
            return ((RedisKeyValueAdapter)this.getRequiredAdapter()).count(keyspace);
        }
        return ((RedisKeyValueAdapter)this.getRequiredAdapter()).execute(connection -> {
            long result = 0L;
            if (!criteria.getOrSismember().isEmpty()) {
                result += (long)connection.sUnion(this.keys(keyspace + ":", criteria.getOrSismember())).size();
            }
            if (!criteria.getSismember().isEmpty()) {
                result += (long)connection.sInter(this.keys(keyspace + ":", criteria.getSismember())).size();
            }
            return result;
        });
    }

    private byte[][] keys(String prefix, Collection<RedisOperationChain.PathAndValue> source) {
        byte[][] keys = new byte[source.size()][];
        int i = 0;
        for (RedisOperationChain.PathAndValue pathAndValue : source) {
            byte[] convertedValue = ((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().getConversionService().convert(pathAndValue.getFirstValue(), byte[].class);
            byte[] fullPath = ((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().getConversionService().convert((Object)(prefix + pathAndValue.getPath() + ":"), byte[].class);
            keys[i] = ByteUtils.concat(fullPath, convertedValue);
            ++i;
        }
        return keys;
    }

    private byte[] geoKey(String prefix, RedisOperationChain.NearPath source) {
        String path = GeoIndexedPropertyValue.geoIndexName(source.getPath());
        return ((RedisKeyValueAdapter)this.getRequiredAdapter()).getConverter().getConversionService().convert((Object)(prefix + path), byte[].class);
    }

    static class RedisCriteriaAccessor
    implements CriteriaAccessor<RedisOperationChain> {
        RedisCriteriaAccessor() {
        }

        @Override
        public RedisOperationChain resolve(KeyValueQuery<?> query) {
            return (RedisOperationChain)query.getCriteria();
        }
    }

    record KeySelector(Collection<byte[]> keys, Set<RedisOperationChain.PathAndValue> setValueLookup) {
        static KeySelector of(RedisConverter converter, Set<RedisOperationChain.PathAndValue> pathAndValues, Class<?> domainType) {
            LinkedHashSet<byte[]> keys = new LinkedHashSet<byte[]>();
            LinkedHashSet<RedisOperationChain.PathAndValue> remainder = new LinkedHashSet<RedisOperationChain.PathAndValue>();
            for (RedisOperationChain.PathAndValue pathAndValue : pathAndValues) {
                PersistentPropertyPath path = converter.getMappingContext().getPersistentPropertyPath(pathAndValue.getPath(), domainType);
                if (((RedisPersistentProperty)path.getLeafProperty()).isIdProperty()) {
                    byte[] key = converter.getConversionService().convert(pathAndValue.getFirstValue(), byte[].class);
                    keys.add(key);
                    continue;
                }
                remainder.add(pathAndValue);
            }
            return new KeySelector(keys, remainder);
        }
    }
}

