/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.redis.repository.query.RedisQueryCreator;
import org.springframework.data.redis.repository.support.RedisRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<KeyValueOperations> keyValueTemplate;

    public RedisRepositoryBean(Bean<KeyValueOperations> keyValueTemplate, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, @Nullable CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.ofNullable(detector));
        Assert.notNull(keyValueTemplate, "Bean holding keyvalue template must not be null");
        this.keyValueTemplate = keyValueTemplate;
    }

    @Override
    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        KeyValueOperations keyValueTemplate = this.getDependencyInstance(this.keyValueTemplate, KeyValueOperations.class);
        return ((CdiRepositoryBean)this).create(() -> new RedisRepositoryFactory(keyValueTemplate, RedisQueryCreator.class), repositoryType);
    }
}

