/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.aot;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.web.PagedModel;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class WebRuntimeHints
implements RuntimeHintsRegistrar {
    WebRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader)) {
            hints.reflection().registerType(PagedModel.class, MemberCategory.INVOKE_PUBLIC_METHODS);
            hints.reflection().registerType(PagedModel.PageMetadata.class, MemberCategory.INVOKE_PUBLIC_METHODS);
            hints.reflection().registerType(TypeReference.of("org.springframework.data.domain.Unpaged"), hint -> hint.onReachableType(SpringDataJacksonConfiguration.PageModule.class));
            hints.reflection().registerType(TypeReference.of("org.springframework.data.web.config.SpringDataJacksonConfiguration$PageModule$PageModelConverter"), hint -> {
                hint.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS);
                hint.onReachableType(SpringDataJacksonConfiguration.PageModule.class);
            });
            hints.reflection().registerType(TypeReference.of("org.springframework.data.web.config.SpringDataJacksonConfiguration$PageModule$PlainPageSerializationWarning"), hint -> {
                hint.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS);
                hint.onReachableType(SpringDataJacksonConfiguration.PageModule.class);
            });
        }
    }
}

