/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.LinkedHashMap;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.DuplicatePolicy;
import redis.clients.jedis.timeseries.EncodingFormat;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;

public class TSAddParams
implements IParams {
    private Long retentionPeriod;
    private EncodingFormat encoding;
    private Long chunkSize;
    private DuplicatePolicy duplicatePolicy;
    private DuplicatePolicy onDuplicate;
    private boolean ignore;
    private long ignoreMaxTimediff;
    private double ignoreMaxValDiff;
    private Map<String, String> labels;

    public static TSAddParams addParams() {
        return new TSAddParams();
    }

    public TSAddParams retention(long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    public TSAddParams encoding(EncodingFormat encoding) {
        this.encoding = encoding;
        return this;
    }

    public TSAddParams chunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public TSAddParams duplicatePolicy(DuplicatePolicy duplicatePolicy) {
        this.duplicatePolicy = duplicatePolicy;
        return this;
    }

    public TSAddParams onDuplicate(DuplicatePolicy onDuplicate) {
        this.onDuplicate = onDuplicate;
        return this;
    }

    public TSAddParams ignore(long maxTimediff, double maxValDiff) {
        this.ignore = true;
        this.ignoreMaxTimediff = maxTimediff;
        this.ignoreMaxValDiff = maxValDiff;
        return this;
    }

    public TSAddParams labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public TSAddParams label(String label, String value) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        this.labels.put(label, value);
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.retentionPeriod != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionPeriod));
        }
        if (this.encoding != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.ENCODING).add(this.encoding);
        }
        if (this.chunkSize != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.CHUNK_SIZE).add(Protocol.toByteArray(this.chunkSize));
        }
        if (this.duplicatePolicy != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.duplicatePolicy != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.onDuplicate != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.ON_DUPLICATE).add(this.onDuplicate);
        }
        if (this.ignore) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.IGNORE).add(this.ignoreMaxTimediff).add(this.ignoreMaxValDiff);
        }
        if (this.labels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> args.add((String)entry.getKey()).add((String)entry.getValue()));
        }
    }
}

