/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class KeysetScrollPosition
implements ScrollPosition {
    private static final KeysetScrollPosition EMPTY_FORWARD = new KeysetScrollPosition(Collections.emptyMap(), ScrollPosition.Direction.FORWARD);
    private static final KeysetScrollPosition EMPTY_BACKWARD = new KeysetScrollPosition(Collections.emptyMap(), ScrollPosition.Direction.BACKWARD);
    private final Map<String, Object> keys;
    private final ScrollPosition.Direction direction;

    private KeysetScrollPosition(Map<String, Object> keys, ScrollPosition.Direction direction) {
        Assert.notNull(keys, "Keys must not be null");
        Assert.notNull((Object)direction, "Direction must not be null");
        this.keys = keys;
        this.direction = direction;
    }

    static KeysetScrollPosition initial() {
        return EMPTY_FORWARD;
    }

    static KeysetScrollPosition of(Map<String, ?> keys, ScrollPosition.Direction direction) {
        Assert.notNull(keys, "Keys must not be null");
        Assert.notNull((Object)direction, "Direction must not be null");
        return keys.isEmpty() ? (direction == ScrollPosition.Direction.FORWARD ? EMPTY_FORWARD : EMPTY_BACKWARD) : new KeysetScrollPosition(Collections.unmodifiableMap(new LinkedHashMap(keys)), direction);
    }

    public Map<String, Object> getKeys() {
        return this.keys;
    }

    public ScrollPosition.Direction getDirection() {
        return this.direction;
    }

    public boolean scrollsForward() {
        return this.direction == ScrollPosition.Direction.FORWARD;
    }

    public boolean scrollsBackward() {
        return this.direction == ScrollPosition.Direction.BACKWARD;
    }

    public KeysetScrollPosition forward() {
        return this.direction == ScrollPosition.Direction.FORWARD ? this : new KeysetScrollPosition(this.keys, ScrollPosition.Direction.FORWARD);
    }

    public KeysetScrollPosition backward() {
        return this.direction == ScrollPosition.Direction.BACKWARD ? this : new KeysetScrollPosition(this.keys, ScrollPosition.Direction.BACKWARD);
    }

    public KeysetScrollPosition reverse() {
        return new KeysetScrollPosition(this.keys, this.direction.reverse());
    }

    @Override
    public boolean isInitial() {
        return this.keys.isEmpty();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysetScrollPosition)) {
            return false;
        }
        KeysetScrollPosition that = (KeysetScrollPosition)o;
        return ObjectUtils.nullSafeEquals(this.keys, that.keys) && this.direction == that.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keys, this.direction});
    }

    public String toString() {
        return String.format("KeysetScrollPosition [%s, %s]", new Object[]{this.direction, this.keys});
    }
}

