/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.keyvalue.annotation.KeySpace;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum AnnotationBasedKeySpaceResolver implements KeySpaceResolver
{
    INSTANCE;


    @Override
    @Nullable
    public String resolveKeySpace(Class<?> type) {
        Assert.notNull(type, "Type for keyspace for null");
        Class<?> userClass = ClassUtils.getUserClass(type);
        Object keySpace = AnnotationBasedKeySpaceResolver.getKeySpace(userClass);
        return keySpace != null ? keySpace.toString() : null;
    }

    @Nullable
    private static Object getKeySpace(Class<?> type) {
        MergedAnnotation<KeySpace> annotation = MergedAnnotations.from(type, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(KeySpace.class);
        if (annotation.isPresent()) {
            return annotation.getValue("value").orElse(null);
        }
        return null;
    }
}

