/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import org.springframework.data.keyvalue.core.mapping.AnnotationBasedKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.ClassNameKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class BasicKeyValuePersistentEntity<T, P extends KeyValuePersistentProperty<P>>
extends BasicPersistentEntity<T, P>
implements KeyValuePersistentEntity<T, P> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    @Nullable
    private final Expression keyspaceExpression;
    @Nullable
    private final String keyspace;

    public BasicKeyValuePersistentEntity(TypeInformation<T> information) {
        this(information, (String)null);
    }

    public BasicKeyValuePersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver) {
        this(information, keySpaceResolver != null ? keySpaceResolver.resolveKeySpace(information.getType()) : null);
    }

    private BasicKeyValuePersistentEntity(TypeInformation<T> information, @Nullable String keyspace) {
        super(information);
        if (StringUtils.hasText(keyspace)) {
            this.keyspace = keyspace;
            this.keyspaceExpression = null;
        } else {
            Class<T> type = information.getType();
            String detectedKeyspace = AnnotationBasedKeySpaceResolver.INSTANCE.resolveKeySpace(type);
            if (StringUtils.hasText(detectedKeyspace)) {
                this.keyspace = detectedKeyspace;
                this.keyspaceExpression = BasicKeyValuePersistentEntity.detectExpression(detectedKeyspace);
            } else {
                this.keyspace = ClassNameKeySpaceResolver.INSTANCE.resolveKeySpace(type);
                this.keyspaceExpression = null;
            }
        }
    }

    @Nullable
    private static Expression detectExpression(String potentialExpression) {
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    @Override
    public String getKeySpace() {
        return this.keyspaceExpression == null ? this.keyspace : this.keyspaceExpression.getValue(this.getEvaluationContext(null), String.class);
    }
}

