/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.function.Consumer;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheConfiguration {
    protected static final boolean DEFAULT_CACHE_NULL_VALUES = true;
    protected static final boolean DEFAULT_ENABLE_TIME_TO_IDLE_EXPIRATION = false;
    protected static final boolean DEFAULT_USE_PREFIX = true;
    protected static final boolean DO_NOT_CACHE_NULL_VALUES = false;
    protected static final boolean DO_NOT_USE_PREFIX = false;
    protected static final boolean USE_TIME_TO_IDLE_EXPIRATION = true;
    private final boolean cacheNullValues;
    private final boolean enableTimeToIdle;
    private final boolean usePrefix;
    private final CacheKeyPrefix keyPrefix;
    private final ConversionService conversionService;
    private final RedisSerializationContext.SerializationPair<String> keySerializationPair;
    private final RedisSerializationContext.SerializationPair<Object> valueSerializationPair;
    private final RedisCacheWriter.TtlFunction ttlFunction;

    public static RedisCacheConfiguration defaultCacheConfig() {
        return RedisCacheConfiguration.defaultCacheConfig(null);
    }

    public static RedisCacheConfiguration defaultCacheConfig(@Nullable ClassLoader classLoader) {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        RedisCacheConfiguration.registerDefaultConverters(conversionService);
        return new RedisCacheConfiguration(RedisCacheWriter.TtlFunction.persistent(), true, false, true, CacheKeyPrefix.simple(), RedisSerializationContext.SerializationPair.fromSerializer(RedisSerializer.string()), RedisSerializationContext.SerializationPair.fromSerializer(RedisSerializer.java(classLoader)), conversionService);
    }

    private RedisCacheConfiguration(RedisCacheWriter.TtlFunction ttlFunction, Boolean cacheNullValues, Boolean enableTimeToIdle, Boolean usePrefix, CacheKeyPrefix keyPrefix, RedisSerializationContext.SerializationPair<String> keySerializationPair, RedisSerializationContext.SerializationPair<?> valueSerializationPair, ConversionService conversionService) {
        this.ttlFunction = ttlFunction;
        this.cacheNullValues = cacheNullValues;
        this.enableTimeToIdle = enableTimeToIdle;
        this.usePrefix = usePrefix;
        this.keyPrefix = keyPrefix;
        this.keySerializationPair = keySerializationPair;
        this.valueSerializationPair = valueSerializationPair;
        this.conversionService = conversionService;
    }

    public RedisCacheConfiguration prefixCacheNameWith(String prefix) {
        return this.computePrefixWith(CacheKeyPrefix.prefixed(prefix));
    }

    public RedisCacheConfiguration computePrefixWith(CacheKeyPrefix cacheKeyPrefix) {
        Assert.notNull((Object)cacheKeyPrefix, "Function used to compute prefix must not be null");
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), true, cacheKeyPrefix, this.getKeySerializationPair(), this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration disableCachingNullValues() {
        return new RedisCacheConfiguration(this.getTtlFunction(), false, this.isTimeToIdleEnabled(), this.usePrefix(), this.getKeyPrefix(), this.getKeySerializationPair(), this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration disableKeyPrefix() {
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), false, this.getKeyPrefix(), this.getKeySerializationPair(), this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration enableTimeToIdle() {
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), true, this.usePrefix(), this.getKeyPrefix(), this.getKeySerializationPair(), this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration entryTtl(Duration ttl) {
        Assert.notNull((Object)ttl, "TTL duration must not be null");
        return this.entryTtl(RedisCacheWriter.TtlFunction.just(ttl));
    }

    public RedisCacheConfiguration entryTtl(RedisCacheWriter.TtlFunction ttlFunction) {
        Assert.notNull((Object)ttlFunction, "TtlFunction must not be null");
        return new RedisCacheConfiguration(ttlFunction, this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), this.usePrefix(), this.getKeyPrefix(), this.getKeySerializationPair(), this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration serializeKeysWith(RedisSerializationContext.SerializationPair<String> keySerializationPair) {
        Assert.notNull(keySerializationPair, "KeySerializationPair must not be null");
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), this.usePrefix(), this.getKeyPrefix(), keySerializationPair, this.getValueSerializationPair(), this.getConversionService());
    }

    public RedisCacheConfiguration serializeValuesWith(RedisSerializationContext.SerializationPair<?> valueSerializationPair) {
        Assert.notNull(valueSerializationPair, "ValueSerializationPair must not be null");
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), this.usePrefix(), this.getKeyPrefix(), this.getKeySerializationPair(), valueSerializationPair, this.getConversionService());
    }

    public RedisCacheConfiguration withConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        return new RedisCacheConfiguration(this.getTtlFunction(), this.getAllowCacheNullValues(), this.isTimeToIdleEnabled(), this.usePrefix(), this.getKeyPrefix(), this.getKeySerializationPair(), this.getValueSerializationPair(), conversionService);
    }

    public boolean getAllowCacheNullValues() {
        return this.cacheNullValues;
    }

    public boolean isTimeToIdleEnabled() {
        return this.enableTimeToIdle;
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public CacheKeyPrefix getKeyPrefix() {
        return this.keyPrefix;
    }

    public String getKeyPrefixFor(String cacheName) {
        Assert.notNull((Object)cacheName, "Cache name must not be null");
        return this.keyPrefix.compute(cacheName);
    }

    public RedisSerializationContext.SerializationPair<String> getKeySerializationPair() {
        return this.keySerializationPair;
    }

    public RedisSerializationContext.SerializationPair<Object> getValueSerializationPair() {
        return this.valueSerializationPair;
    }

    @Deprecated(since="3.2")
    public Duration getTtl() {
        return this.getTtlFunction().getTimeToLive(Object.class, null);
    }

    public RedisCacheWriter.TtlFunction getTtlFunction() {
        return this.ttlFunction;
    }

    public void addCacheKeyConverter(Converter<?, String> cacheKeyConverter) {
        this.configureKeyConverters(it -> it.addConverter(cacheKeyConverter));
    }

    public void configureKeyConverters(Consumer<ConverterRegistry> registryConsumer) {
        if (!(this.getConversionService() instanceof ConverterRegistry)) {
            String message = "'%s' returned by getConversionService() does not allow Converter registration; Please make sure to provide a ConversionService that implements ConverterRegistry";
            throw new IllegalStateException(String.format(message, this.getConversionService().getClass().getName()));
        }
        registryConsumer.accept((ConverterRegistry)((Object)this.getConversionService()));
    }

    public static void registerDefaultConverters(ConverterRegistry registry) {
        Assert.notNull((Object)registry, "ConverterRegistry must not be null");
        registry.addConverter(String.class, byte[].class, source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(SimpleKey.class, String.class, SimpleKey::toString);
    }
}

