/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedisPubSub;

class JedisMessageListener
extends BinaryJedisPubSub {
    private final MessageListener listener;
    private final SubscriptionListener subscriptionListener;

    JedisMessageListener(MessageListener listener) {
        Assert.notNull((Object)listener, "MessageListener is required");
        this.listener = listener;
        this.subscriptionListener = listener instanceof SubscriptionListener ? (SubscriptionListener)((Object)listener) : SubscriptionListener.NO_OP_SUBSCRIPTION_LISTENER;
    }

    @Override
    public void onMessage(byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), null);
    }

    @Override
    public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), pattern);
    }

    @Override
    public void onPSubscribe(byte[] pattern, int subscribedChannels) {
        this.subscriptionListener.onPatternSubscribed(pattern, subscribedChannels);
    }

    @Override
    public void onPUnsubscribe(byte[] pattern, int subscribedChannels) {
        this.subscriptionListener.onPatternUnsubscribed(pattern, subscribedChannels);
    }

    @Override
    public void onSubscribe(byte[] channel, int subscribedChannels) {
        this.subscriptionListener.onChannelSubscribed(channel, subscribedChannels);
    }

    @Override
    public void onUnsubscribe(byte[] channel, int subscribedChannels) {
        this.subscriptionListener.onChannelUnsubscribed(channel, subscribedChannels);
    }
}

