/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;

class JedisScriptingCommands
implements RedisScriptingCommands {
    private final JedisConnection connection;

    JedisScriptingCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void scriptFlush() {
        this.assertDirectMode();
        this.connection.invoke().just(Jedis::scriptFlush);
    }

    @Override
    public void scriptKill() {
        this.assertDirectMode();
        this.connection.invoke().just(Jedis::scriptKill);
    }

    @Override
    public String scriptLoad(byte[] script) {
        Assert.notNull((Object)script, "Script must not be null");
        this.assertDirectMode();
        return this.connection.invoke().from(it -> it.scriptLoad(script)).get(JedisConverters::toString);
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        Assert.notNull((Object)scriptSha1, "Script digests must not be null");
        Assert.noNullElements((Object[])scriptSha1, "Script digests must not contain null elements");
        this.assertDirectMode();
        return this.connection.invoke().just(it -> it.scriptExists(scriptSha1));
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, "Script must not be null");
        this.assertDirectMode();
        JedisScriptReturnConverter converter = new JedisScriptReturnConverter(returnType);
        return (T)this.connection.invoke().from(it -> it.eval(script, numKeys, keysAndArgs)).getOrElse(converter, () -> converter.convert((Object)null));
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(JedisConverters.toBytes(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    @Override
    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha, "Script digest must not be null");
        this.assertDirectMode();
        JedisScriptReturnConverter converter = new JedisScriptReturnConverter(returnType);
        return (T)this.connection.invoke().from(it -> it.evalsha(scriptSha, numKeys, keysAndArgs)).getOrElse(converter, () -> converter.convert((Object)null));
    }

    private void assertDirectMode() {
        if (this.connection.isQueueing() || this.connection.isPipelined()) {
            throw new InvalidDataAccessApiUsageException("Scripting commands not supported in pipelining/transaction mode");
        }
    }
}

