/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.Cursor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertingCursor<S, T>
implements Cursor<T> {
    private final Cursor<S> delegate;
    private final Converter<S, T> converter;

    public ConvertingCursor(Cursor<S> cursor, Converter<S, T> converter) {
        Assert.notNull(cursor, "Cursor must not be null");
        Assert.notNull(converter, "Converter must not be null");
        this.delegate = cursor;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    @Nullable
    public T next() {
        return this.converter.convert(this.delegate.next());
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Cursor.CursorId getId() {
        return this.delegate.getId();
    }

    @Override
    @Deprecated
    public long getCursorId() {
        return this.delegate.getCursorId();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public long getPosition() {
        return this.delegate.getPosition();
    }
}

