/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.convert.BinaryConverters;

public abstract class Jsr310Converters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList(20);
        converters.add(new LocalDateTimeToBytesConverter());
        converters.add(new BytesToLocalDateTimeConverter());
        converters.add(new LocalDateToBytesConverter());
        converters.add(new BytesToLocalDateConverter());
        converters.add(new LocalTimeToBytesConverter());
        converters.add(new BytesToLocalTimeConverter());
        converters.add(new ZonedDateTimeToBytesConverter());
        converters.add(new BytesToZonedDateTimeConverter());
        converters.add(new InstantToBytesConverter());
        converters.add(new BytesToInstantConverter());
        converters.add(new ZoneIdToBytesConverter());
        converters.add(new BytesToZoneIdConverter());
        converters.add(new PeriodToBytesConverter());
        converters.add(new BytesToPeriodConverter());
        converters.add(new DurationToBytesConverter());
        converters.add(new BytesToDurationConverter());
        converters.add(new OffsetDateTimeToBytesConverter());
        converters.add(new BytesToOffsetDateTimeConverter());
        converters.add(new OffsetTimeToBytesConverter());
        converters.add(new BytesToOffsetTimeConverter());
        return converters;
    }

    public static boolean supports(Class<?> type) {
        return Arrays.asList(LocalDateTime.class, LocalDate.class, LocalTime.class, Instant.class, ZonedDateTime.class, ZoneId.class, Period.class, Duration.class, OffsetDateTime.class, OffsetTime.class).contains(type);
    }

    static class LocalDateTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalDateTime, byte[]> {
        LocalDateTimeToBytesConverter() {
        }

        @Override
        public byte[] convert(LocalDateTime source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToLocalDateTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalDateTime> {
        BytesToLocalDateTimeConverter() {
        }

        @Override
        public LocalDateTime convert(byte[] source) {
            return LocalDateTime.parse(this.toString(source));
        }
    }

    static class LocalDateToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalDate, byte[]> {
        LocalDateToBytesConverter() {
        }

        @Override
        public byte[] convert(LocalDate source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToLocalDateConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalDate> {
        BytesToLocalDateConverter() {
        }

        @Override
        public LocalDate convert(byte[] source) {
            return LocalDate.parse(this.toString(source));
        }
    }

    static class LocalTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalTime, byte[]> {
        LocalTimeToBytesConverter() {
        }

        @Override
        public byte[] convert(LocalTime source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToLocalTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalTime> {
        BytesToLocalTimeConverter() {
        }

        @Override
        public LocalTime convert(byte[] source) {
            return LocalTime.parse(this.toString(source));
        }
    }

    static class ZonedDateTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<ZonedDateTime, byte[]> {
        ZonedDateTimeToBytesConverter() {
        }

        @Override
        public byte[] convert(ZonedDateTime source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToZonedDateTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], ZonedDateTime> {
        BytesToZonedDateTimeConverter() {
        }

        @Override
        public ZonedDateTime convert(byte[] source) {
            return ZonedDateTime.parse(this.toString(source));
        }
    }

    static class InstantToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Instant, byte[]> {
        InstantToBytesConverter() {
        }

        @Override
        public byte[] convert(Instant source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToInstantConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Instant> {
        BytesToInstantConverter() {
        }

        @Override
        public Instant convert(byte[] source) {
            return Instant.parse(this.toString(source));
        }
    }

    static class ZoneIdToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<ZoneId, byte[]> {
        ZoneIdToBytesConverter() {
        }

        @Override
        public byte[] convert(ZoneId source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToZoneIdConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], ZoneId> {
        BytesToZoneIdConverter() {
        }

        @Override
        public ZoneId convert(byte[] source) {
            return ZoneId.of(this.toString(source));
        }
    }

    static class PeriodToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Period, byte[]> {
        PeriodToBytesConverter() {
        }

        @Override
        public byte[] convert(Period source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToPeriodConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Period> {
        BytesToPeriodConverter() {
        }

        @Override
        public Period convert(byte[] source) {
            return Period.parse(this.toString(source));
        }
    }

    static class DurationToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Duration, byte[]> {
        DurationToBytesConverter() {
        }

        @Override
        public byte[] convert(Duration source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToDurationConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Duration> {
        BytesToDurationConverter() {
        }

        @Override
        public Duration convert(byte[] source) {
            return Duration.parse(this.toString(source));
        }
    }

    static class OffsetDateTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<OffsetDateTime, byte[]> {
        OffsetDateTimeToBytesConverter() {
        }

        @Override
        public byte[] convert(OffsetDateTime source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToOffsetDateTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], OffsetDateTime> {
        BytesToOffsetDateTimeConverter() {
        }

        @Override
        public OffsetDateTime convert(byte[] source) {
            return OffsetDateTime.parse(this.toString(source));
        }
    }

    static class OffsetTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<OffsetTime, byte[]> {
        OffsetTimeToBytesConverter() {
        }

        @Override
        public byte[] convert(OffsetTime source) {
            return this.fromString(source.toString());
        }
    }

    static class BytesToOffsetTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], OffsetTime> {
        BytesToOffsetTimeConverter() {
        }

        @Override
        public OffsetTime convert(byte[] source) {
            return OffsetTime.parse(this.toString(source));
        }
    }
}

