/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Map;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReferenceResolverImpl
implements ReferenceResolver {
    private final RedisOperations<?, ?> redisOps;
    private final BinaryConverters.StringToBytesConverter converter;

    public ReferenceResolverImpl(RedisOperations<?, ?> redisOperations) {
        Assert.notNull(redisOperations, "RedisOperations must not be null");
        this.redisOps = redisOperations;
        this.converter = new BinaryConverters.StringToBytesConverter();
    }

    @Override
    @Nullable
    public Map<byte[], byte[]> resolveReference(Object id, String keyspace) {
        byte[] key = this.converter.convert(keyspace + ":" + id);
        return this.redisOps.execute(connection -> connection.hGetAll(key));
    }
}

