/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptingException;
import org.springframework.lang.Nullable;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;

public class DefaultRedisScript<T>
implements RedisScript<T>,
InitializingBean {
    @Nullable
    private Class<T> resultType;
    private final Lock lock = new ReentrantLock();
    @Nullable
    private ScriptSource scriptSource;
    @Nullable
    private String sha1;

    public DefaultRedisScript() {
    }

    public DefaultRedisScript(String script) {
        this(script, null);
    }

    public DefaultRedisScript(String script, @Nullable Class<T> resultType) {
        this.setScriptText(script);
        this.resultType = resultType;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.scriptSource != null, "Either script, script location, or script source is required");
    }

    @Override
    public String getSha1() {
        this.lock.lock();
        try {
            if (this.sha1 == null || this.scriptSource.isModified()) {
                this.sha1 = DigestUtils.sha1DigestAsHex(this.getScriptAsString());
            }
            String string = this.sha1;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public Class<T> getResultType() {
        return this.resultType;
    }

    @Override
    public String getScriptAsString() {
        try {
            return this.scriptSource.getScriptAsString();
        }
        catch (IOException ex) {
            throw new ScriptingException("Error reading script text", ex);
        }
    }

    public void setResultType(@Nullable Class<T> resultType) {
        this.resultType = resultType;
    }

    public void setScriptText(String scriptText) {
        this.scriptSource = new StaticScriptSource(scriptText);
    }

    public void setLocation(Resource scriptLocation) {
        this.scriptSource = new ResourceScriptSource(scriptLocation);
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }
}

