/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.adapter.RedisListenerExecutionFailedException;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessageListenerAdapter
implements InitializingBean,
MessageListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private volatile Object delegate;
    @Nullable
    private volatile MethodInvoker invoker;
    private String defaultListenerMethod = "handleMessage";
    @Nullable
    private RedisSerializer<?> serializer;
    @Nullable
    private RedisSerializer<String> stringSerializer;

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    public MessageListenerAdapter(Object delegate, String defaultListenerMethod) {
        this(delegate);
        this.setDefaultListenerMethod(defaultListenerMethod);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
    }

    @Nullable
    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setStringSerializer(RedisSerializer<String> serializer) {
        this.stringSerializer = serializer;
    }

    @Override
    public void afterPropertiesSet() {
        String methodName = this.getDefaultListenerMethod();
        if (!StringUtils.hasText(methodName)) {
            throw new InvalidDataAccessApiUsageException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method");
        }
        this.invoker = new MethodInvoker(this.delegate, methodName);
    }

    @Override
    public void onMessage(Message message, @Nullable byte[] pattern) {
        try {
            if (this.delegate != this && this.delegate instanceof MessageListener) {
                ((MessageListener)this.delegate).onMessage(message, pattern);
                return;
            }
            Object convertedMessage = this.extractMessage(message);
            String convertedChannel = this.stringSerializer.deserialize(pattern);
            Object[] listenerArguments = new Object[]{convertedMessage, convertedChannel};
            this.invokeListenerMethod(this.invoker.getMethodName(), listenerArguments);
        }
        catch (Throwable th) {
            this.handleListenerException(th);
        }
    }

    protected void initDefaultStrategies() {
        this.setSerializer(RedisSerializer.string());
        this.setStringSerializer(RedisSerializer.string());
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error("Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        if (this.serializer != null) {
            return this.serializer.deserialize(message.getBody());
        }
        return message.getBody();
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) {
        return this.getDefaultListenerMethod();
    }

    protected void invokeListenerMethod(String methodName, Object[] arguments) {
        try {
            this.invoker.invoke(arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof DataAccessException) {
                DataAccessException dataAccessException = (DataAccessException)targetEx;
                throw dataAccessException;
            }
            String message = String.format("Listener method '%s' threw exception", methodName);
            throw new RedisListenerExecutionFailedException(message, targetEx);
        }
        catch (Throwable ex) {
            String message = String.format("Failed to invoke target method '%s' with arguments %s", methodName, ObjectUtils.nullSafeToString(arguments));
            throw new RedisListenerExecutionFailedException(message, ex);
        }
    }

    private class MethodInvoker {
        private final Object delegate;
        private String methodName;
        private Set<Method> methods;
        private boolean lenient;

        MethodInvoker(Object delegate, String methodName) {
            this.delegate = delegate;
            this.methodName = methodName;
            this.lenient = delegate instanceof MessageListener;
            this.methods = new HashSet<Method>();
            Class<?> c = delegate.getClass();
            ReflectionUtils.doWithMethods(c, method -> {
                ReflectionUtils.makeAccessible(method);
                this.methods.add(method);
            }, new MostSpecificMethodFilter(methodName, c));
            Assert.isTrue(this.lenient || !this.methods.isEmpty(), "Cannot find a suitable method named [" + c.getName() + "#" + methodName + "] - is the method public and has the proper arguments");
        }

        void invoke(Object[] arguments) throws InvocationTargetException, IllegalAccessException {
            Object[] message = new Object[]{arguments[0]};
            for (Method m : this.methods) {
                Object[] args;
                Class<?>[] types = m.getParameterTypes();
                Object[] objectArray = args = types.length == 2 && types[0].isInstance(arguments[0]) && types[1].isInstance(arguments[1]) ? arguments : message;
                if (!types[0].isInstance(args[0])) continue;
                m.invoke(this.delegate, args);
                return;
            }
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    static final class MostSpecificMethodFilter
    implements ReflectionUtils.MethodFilter {
        private final String methodName;
        private final Class<?> c;

        MostSpecificMethodFilter(String methodName, Class<?> c) {
            this.methodName = methodName;
            this.c = c;
        }

        @Override
        public boolean matches(Method method) {
            if (Modifier.isPublic(method.getModifiers()) && this.methodName.equals(method.getName()) && method.equals(ClassUtils.getMostSpecificMethod(method, this.c))) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                return parameterTypes.length == 2 && String.class.equals(parameterTypes[1]) || parameterTypes.length == 1;
            }
            return false;
        }
    }
}

