/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.CollectionUtils;

public class RedisQueryCreator
extends AbstractQueryCreator<KeyValueQuery<RedisOperationChain>, RedisOperationChain> {
    public RedisQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    @Override
    protected RedisOperationChain create(Part part, Iterator<Object> iterator) {
        return this.from(part, iterator, new RedisOperationChain());
    }

    private RedisOperationChain from(Part part, Iterator<Object> iterator, RedisOperationChain sink) {
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                sink.sismember(part.getProperty().toDotPath(), iterator.next());
                break;
            }
            case TRUE: {
                sink.sismember(part.getProperty().toDotPath(), true);
                break;
            }
            case FALSE: {
                sink.sismember(part.getProperty().toDotPath(), false);
                break;
            }
            case WITHIN: 
            case NEAR: {
                sink.near(this.getNearPath(part, iterator));
                break;
            }
            default: {
                String message = String.format("%s is not supported for Redis query derivation", new Object[]{part.getType()});
                throw new IllegalArgumentException(message);
            }
        }
        return sink;
    }

    @Override
    protected RedisOperationChain and(Part part, RedisOperationChain base, Iterator<Object> iterator) {
        return this.from(part, iterator, base);
    }

    @Override
    protected RedisOperationChain or(RedisOperationChain base, RedisOperationChain criteria) {
        base.orSismember(criteria.getSismember());
        return base;
    }

    @Override
    protected KeyValueQuery<RedisOperationChain> complete(RedisOperationChain criteria, Sort sort) {
        KeyValueQuery<RedisOperationChain> query = new KeyValueQuery<RedisOperationChain>(criteria);
        if (query.getCriteria() != null && !CollectionUtils.isEmpty(query.getCriteria().getSismember()) && !CollectionUtils.isEmpty(query.getCriteria().getOrSismember()) && query.getCriteria().getSismember().size() == 1 && query.getCriteria().getOrSismember().size() == 1) {
            query.getCriteria().getOrSismember().add(query.getCriteria().getSismember().iterator().next());
            query.getCriteria().getSismember().clear();
        }
        if (sort.isSorted()) {
            query.setSort(sort);
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RedisOperationChain.NearPath getNearPath(Part part, Iterator<Object> iterator) {
        Distance distance;
        Point point;
        Object value = iterator.next();
        if (value instanceof Circle) {
            point = ((Circle)value).getCenter();
            distance = ((Circle)value).getRadius();
            return new RedisOperationChain.NearPath(part.getProperty().toDotPath(), point, distance);
        }
        if (!(value instanceof Point)) {
            String message = String.format("Expected to find a Circle or Point/Distance for geo query but was %s.", value.getClass());
            throw new InvalidDataAccessApiUsageException(message);
        }
        point = (Point)value;
        if (!iterator.hasNext()) {
            String message = "Expected to find distance value for geo query; Are you missing a parameter";
            throw new InvalidDataAccessApiUsageException(message);
        }
        Object distObject = iterator.next();
        if (distObject instanceof Distance) {
            distance = (Distance)distObject;
            return new RedisOperationChain.NearPath(part.getProperty().toDotPath(), point, distance);
        }
        if (distObject instanceof Number) {
            distance = new Distance(((Number)distObject).doubleValue(), Metrics.KILOMETERS);
            return new RedisOperationChain.NearPath(part.getProperty().toDotPath(), point, distance);
        }
        String message = String.format("Expected to find Distance or Numeric value for geo query but was %s", distObject.getClass());
        throw new InvalidDataAccessApiUsageException(message);
    }
}

