/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.JacksonObjectReader;
import org.springframework.data.redis.serializer.JacksonObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Jackson2JsonRedisSerializer<T>
implements RedisSerializer<T> {
    @Deprecated(since="3.0", forRemoval=true)
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final JavaType javaType;
    private ObjectMapper mapper;
    private final JacksonObjectReader reader;
    private final JacksonObjectWriter writer;

    public Jackson2JsonRedisSerializer(Class<T> type) {
        this(new ObjectMapper(), type);
    }

    public Jackson2JsonRedisSerializer(JavaType javaType) {
        this(new ObjectMapper(), javaType);
    }

    public Jackson2JsonRedisSerializer(ObjectMapper mapper, Class<T> type) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null");
        Assert.notNull(type, "Java type must not be null");
        this.javaType = this.getJavaType(type);
        this.mapper = mapper;
        this.reader = JacksonObjectReader.create();
        this.writer = JacksonObjectWriter.create();
    }

    public Jackson2JsonRedisSerializer(ObjectMapper mapper, JavaType javaType) {
        this(mapper, javaType, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public Jackson2JsonRedisSerializer(ObjectMapper mapper, JavaType javaType, JacksonObjectReader reader, JacksonObjectWriter writer) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null!");
        Assert.notNull((Object)reader, "Reader must not be null!");
        Assert.notNull((Object)writer, "Writer must not be null!");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.javaType = javaType;
    }

    @Deprecated(since="3.0", forRemoval=true)
    public void setObjectMapper(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, "'objectMapper' must not be null");
        this.mapper = mapper;
    }

    @Override
    public byte[] serialize(@Nullable T value) throws SerializationException {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, value);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not write JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public T deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, bytes, this.javaType);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }
}

