/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.redis.util.RedisAssertions;
import org.springframework.lang.Nullable;

public class JdkSerializationRedisSerializer
implements RedisSerializer<Object> {
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;

    public JdkSerializationRedisSerializer() {
        this(new SerializingConverter(), new DeserializingConverter());
    }

    public JdkSerializationRedisSerializer(@Nullable ClassLoader classLoader) {
        this(new SerializingConverter(), new DeserializingConverter(classLoader));
    }

    public JdkSerializationRedisSerializer(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer) {
        this.serializer = RedisAssertions.requireNonNull(serializer, "Serializer must not be null", new Object[0]);
        this.deserializer = RedisAssertions.requireNonNull(deserializer, "Deserializer must not be null", new Object[0]);
    }

    @Override
    public byte[] serialize(@Nullable Object value) {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.serializer.convert(value);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize", ex);
        }
    }

    @Override
    public Object deserialize(@Nullable byte[] bytes) {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.deserializer.convert(bytes);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize", ex);
        }
    }
}

