/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.QueryAnnotation;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class RepositoryInformationSupport
implements RepositoryInformation {
    private final Supplier<RepositoryMetadata> metadata;
    private final Supplier<Class<?>> repositoryBaseClass;
    private final Supplier<DefaultQueryMethods> queryMethods;

    public RepositoryInformationSupport(Supplier<RepositoryMetadata> metadata, Supplier<Class<?>> repositoryBaseClass) {
        Assert.notNull(metadata, "Repository metadata must not be null");
        Assert.notNull(repositoryBaseClass, "Repository base class must not be null");
        this.metadata = Lazy.of(metadata);
        this.repositoryBaseClass = Lazy.of(repositoryBaseClass);
        this.queryMethods = Lazy.of(this::calculateQueryMethods);
    }

    @Override
    public Streamable<Method> getQueryMethods() {
        return this.queryMethods.get().methods;
    }

    @Override
    public Class<?> getIdType() {
        return this.getMetadata().getIdType();
    }

    @Override
    public Class<?> getDomainType() {
        return this.getMetadata().getDomainType();
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.getMetadata().getRepositoryInterface();
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return this.getMetadata().getReturnType(method);
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        return this.getMetadata().getReturnedDomainClass(method);
    }

    @Override
    public CrudMethods getCrudMethods() {
        return this.getMetadata().getCrudMethods();
    }

    @Override
    public boolean isPagingRepository() {
        return this.getMetadata().isPagingRepository();
    }

    @Override
    public Set<Class<?>> getAlternativeDomainTypes() {
        return this.getMetadata().getAlternativeDomainTypes();
    }

    @Override
    public boolean isReactiveRepository() {
        return this.getMetadata().isReactiveRepository();
    }

    @Override
    public Class<?> getRepositoryBaseClass() {
        return this.repositoryBaseClass.get();
    }

    @Override
    public boolean isQueryMethod(Method method) {
        return this.getQueryMethods().stream().anyMatch(it -> it.equals(method));
    }

    @Override
    public TypeInformation<?> getDomainTypeInformation() {
        return this.getMetadata().getDomainTypeInformation();
    }

    @Override
    public TypeInformation<?> getIdTypeInformation() {
        return this.getMetadata().getIdTypeInformation();
    }

    @Override
    public boolean hasCustomMethod() {
        return this.queryMethods.get().hasCustomMethod;
    }

    @Override
    public boolean hasQueryMethods() {
        return this.queryMethods.get().hasQueryMethod;
    }

    protected boolean isQueryAnnotationPresentOn(Method method) {
        return AnnotationUtils.findAnnotation(method, QueryAnnotation.class) != null;
    }

    protected boolean isQueryMethodCandidate(Method method) {
        return !method.isBridge() && !method.isDefault() && !Modifier.isStatic(method.getModifiers()) && (this.isQueryAnnotationPresentOn(method) || !this.isCustomMethod(method) && !this.isBaseClassMethod(method));
    }

    private RepositoryMetadata getMetadata() {
        return this.metadata.get();
    }

    private final DefaultQueryMethods calculateQueryMethods() {
        Class<?> repositoryInterface = this.getRepositoryInterface();
        return new DefaultQueryMethods(Streamable.of(Arrays.stream(repositoryInterface.getMethods()).map(it -> ClassUtils.getMostSpecificMethod(it, repositoryInterface)).filter(this::isQueryMethodCandidate).toList()), this.calculateHasCustomMethod(repositoryInterface));
    }

    private final boolean calculateHasCustomMethod(Class<?> repositoryInterface) {
        if (org.springframework.data.repository.util.ClassUtils.isGenericRepositoryInterface(repositoryInterface)) {
            return false;
        }
        for (Method method : repositoryInterface.getMethods()) {
            if (!this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            return true;
        }
        return false;
    }

    private static class DefaultQueryMethods {
        private final Streamable<Method> methods;
        private final boolean hasCustomMethod;
        private final boolean hasQueryMethod;

        DefaultQueryMethods(Streamable<Method> methods, boolean hasCustomMethod) {
            this.methods = methods;
            this.hasCustomMethod = hasCustomMethod;
            this.hasQueryMethod = !methods.isEmpty();
        }
    }
}

