/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.web.SpringDataAnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class OffsetScrollPositionHandlerMethodArgumentResolverSupport {
    private static final String DEFAULT_PARAMETER = "offset";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private String offsetParameter = "offset";
    private String qualifierDelimiter = "_";

    public void setOffsetParameter(String offsetParameter) {
        Assert.hasText(offsetParameter, "offsetParameter must not be null nor empty");
        this.offsetParameter = offsetParameter;
    }

    public void setQualifierDelimiter(@Nullable String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    protected String getOffsetParameter(MethodParameter parameter) {
        StringBuilder builder = new StringBuilder();
        String value = SpringDataAnnotationUtils.getQualifier(parameter);
        if (StringUtils.hasLength(value)) {
            builder.append(value);
            builder.append(this.qualifierDelimiter);
        }
        return builder.append(this.offsetParameter).toString();
    }

    @Nullable
    OffsetScrollPosition parseParameterIntoOffsetScrollPosition(@Nullable List<String> source) {
        if (CollectionUtils.isEmpty(source) || source.size() == 1 && !StringUtils.hasText(source.get(0))) {
            return null;
        }
        try {
            long offset = Long.parseLong(source.get(0));
            return ScrollPosition.offset(offset);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    Object adaptArgumentIfNecessary(@Nullable Object arg, MethodParameter parameter) {
        if (parameter.getParameterType() == Optional.class) {
            return arg == null ? Optional.empty() : Optional.of(arg);
        }
        return arg;
    }
}

