/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.ProjectingArgumentResolverRegistrar;
import org.springframework.data.web.config.QuerydslWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonModules;
import org.springframework.data.web.config.SpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataWebSettings;
import org.springframework.util.ClassUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Inherited
@Import(value={SpringDataWebConfigurationImportSelector.class, QuerydslActivator.class, SpringDataWebSettingsRegistar.class})
public @interface EnableSpringDataWebSupport {
    public PageSerializationMode pageSerializationMode() default PageSerializationMode.DIRECT;

    public static class SpringDataWebSettingsRegistar
    implements ImportBeanDefinitionRegistrar {
        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
            Map<String, Object> attributes = importingClassMetadata.getAnnotationAttributes(EnableSpringDataWebSupport.class.getName());
            if (attributes == null) {
                return;
            }
            AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition(SpringDataWebSettings.class).addConstructorArgValue(attributes.get("pageSerializationMode")).getBeanDefinition();
            String beanName = importBeanNameGenerator.generateBeanName(definition, registry);
            registry.registerBeanDefinition(beanName, definition);
        }
    }

    public static class QuerydslActivator
    implements ImportSelector {
        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            if (QuerydslUtils.QUERY_DSL_PRESENT) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = QuerydslWebConfiguration.class.getName();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    public static class SpringDataWebConfigurationImportSelector
    implements ImportSelector,
    ResourceLoaderAware {
        private Optional<ClassLoader> resourceLoader = Optional.empty();

        @Override
        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = Optional.of(resourceLoader).map(ResourceLoader::getClassLoader);
        }

        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            ArrayList<String> imports = new ArrayList<String>();
            imports.add(ProjectingArgumentResolverRegistrar.class.getName());
            imports.add(this.resourceLoader.filter(it -> ClassUtils.isPresent("org.springframework.hateoas.Link", it)).map(it -> HateoasAwareSpringDataWebConfiguration.class.getName()).orElseGet(() -> SpringDataWebConfiguration.class.getName()));
            this.resourceLoader.filter(it -> ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", it)).map(it -> SpringFactoriesLoader.loadFactoryNames(SpringDataJacksonModules.class, it)).ifPresent(it -> imports.addAll((Collection<String>)it));
            return imports.toArray(new String[imports.size()]);
        }
    }

    public static enum PageSerializationMode {
        DIRECT,
        VIA_DTO;

    }
}

