/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ExpressionAuthorizationDecision;

final class ExpressionUtils {
    private ExpressionUtils() {
    }

    static AuthorizationResult evaluate(Expression expr, EvaluationContext ctx) {
        try {
            Object result = expr.getValue(ctx);
            if (result instanceof AuthorizationResult) {
                AuthorizationResult decision = (AuthorizationResult)result;
                return decision;
            }
            if (result instanceof Boolean) {
                Boolean granted = (Boolean)result;
                return new ExpressionAuthorizationDecision(granted, expr);
            }
            if (result == null) {
                return null;
            }
            throw new IllegalArgumentException("SpEL expression must return either a Boolean or an AuthorizationDecision");
        }
        catch (EvaluationException ex) {
            throw new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex);
        }
    }
}

