/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.DeferringMethodInterceptor;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(value="_jsr250MethodSecurityConfiguration", proxyBeanMethods=false)
@Role(value=2)
final class Jsr250MethodSecurityConfiguration
implements ImportAware,
AopInfrastructureBean {
    private static final Pointcut pointcut = AuthorizationManagerBeforeMethodInterceptor.jsr250().getPointcut();
    private final Jsr250AuthorizationManager authorizationManager = new Jsr250AuthorizationManager();
    private AuthorizationManagerBeforeMethodInterceptor methodInterceptor = AuthorizationManagerBeforeMethodInterceptor.jsr250(this.authorizationManager);

    Jsr250MethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor jsr250AuthorizationMethodInterceptor(ObjectProvider<Jsr250MethodSecurityConfiguration> _jsr250MethodSecurityConfiguration) {
        Supplier<AuthorizationManagerBeforeMethodInterceptor> supplier = () -> {
            Jsr250MethodSecurityConfiguration configuration = (Jsr250MethodSecurityConfiguration)_jsr250MethodSecurityConfiguration.getObject();
            return configuration.methodInterceptor;
        };
        return new DeferringMethodInterceptor<AuthorizationManagerBeforeMethodInterceptor>(pointcut, supplier);
    }

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.methodInterceptor.setOrder(this.methodInterceptor.getOrder() + annotation.offset());
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults defaults) {
        this.authorizationManager.setRolePrefix(defaults.getRolePrefix());
    }

    @Autowired(required=false)
    void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        AuthoritiesAuthorizationManager authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
        authoritiesAuthorizationManager.setRoleHierarchy(roleHierarchy);
        this.authorizationManager.setAuthoritiesAuthorizationManager(authoritiesAuthorizationManager);
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.methodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
    }

    @Autowired(required=false)
    void setObservationRegistry(ObservationRegistry registry) {
        if (registry.isNoop()) {
            return;
        }
        ObservationAuthorizationManager<MethodInvocation> observed = new ObservationAuthorizationManager<MethodInvocation>(registry, this.authorizationManager);
        this.methodInterceptor = AuthorizationManagerBeforeMethodInterceptor.secured(observed);
    }

    @Autowired(required=false)
    void setEventPublisher(AuthorizationEventPublisher eventPublisher) {
        this.methodInterceptor.setAuthorizationEventPublisher(eventPublisher);
    }
}

