/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.rsocket;

import io.rsocket.plugins.SocketAcceptorInterceptor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.rsocket.RSocketSecurity;
import org.springframework.security.rsocket.core.PayloadSocketAcceptorInterceptor;
import org.springframework.security.rsocket.core.SecuritySocketAcceptorInterceptor;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcher;

@Configuration(proxyBeanMethods=false)
class SecuritySocketAcceptorInterceptorConfiguration {
    SecuritySocketAcceptorInterceptorConfiguration() {
    }

    @Bean
    SecuritySocketAcceptorInterceptor securitySocketAcceptorInterceptor(ObjectProvider<PayloadSocketAcceptorInterceptor> rsocketInterceptor, ObjectProvider<RSocketSecurity> rsocketSecurity) {
        PayloadSocketAcceptorInterceptor delegate = rsocketInterceptor.getIfAvailable(() -> this.defaultInterceptor(rsocketSecurity));
        return new SecuritySocketAcceptorInterceptor((SocketAcceptorInterceptor)delegate);
    }

    private PayloadSocketAcceptorInterceptor defaultInterceptor(ObjectProvider<RSocketSecurity> rsocketSecurity) {
        RSocketSecurity rsocket = rsocketSecurity.getIfAvailable();
        if (rsocket == null) {
            throw new NoSuchBeanDefinitionException("No RSocketSecurity defined");
        }
        rsocket.basicAuthentication(Customizer.withDefaults()).simpleAuthentication(Customizer.withDefaults()).authorizePayload(authz -> authz.setup().authenticated().anyRequest().authenticated().matcher(e -> PayloadExchangeMatcher.MatchResult.match()).permitAll());
        return rsocket.build();
    }
}

