/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;

final class WebConfigUtils {
    private WebConfigUtils() {
    }

    static int countNonEmpty(String[] objects) {
        int nonNulls = 0;
        for (String object : objects) {
            if (!StringUtils.hasText(object)) continue;
            ++nonNulls;
        }
        return nonNulls;
    }

    static void validateHttpRedirect(String url, ParserContext pc, Object source) {
        if (!StringUtils.hasText(url) || UrlUtils.isValidRedirectUrl((String)url) || url.startsWith("$") || url.startsWith("#")) {
            return;
        }
        pc.getReaderContext().warning(url + " is not a valid redirect URL (must start with '/' or http(s))", source);
    }
}

