/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security.config;

import org.apache.camel.component.spring.security.SpringSecurityAuthorizationPolicy;
import org.apache.camel.component.spring.security.config.BeanDefinitionParser;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class SpringSecurityAuthorizationPolicyParser
extends BeanDefinitionParser {
    public SpringSecurityAuthorizationPolicyParser() {
        super(SpringSecurityAuthorizationPolicy.class, true);
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        if ("access".equals(attributeName) || "authorizationManager".equals(attributeName) || "authenticationManager".equals(attributeName)) {
            return false;
        }
        return super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        this.setReferenceIfAttributeDefine(builder, element, "authorizationManager");
        this.setReferenceIfAttributeDefine(builder, element, "authenticationManager");
        if (ObjectHelper.isNotEmpty(element.getAttribute("authenticationAdapter"))) {
            builder.addPropertyReference("authenticationAdapter", element.getAttribute("authenticationAdapter"));
        }
    }

    protected void setReferenceIfAttributeDefine(BeanDefinitionBuilder builder, Element element, String attribute) {
        String valueRef = attribute;
        if (ObjectHelper.isNotEmpty(element.getAttribute(attribute))) {
            valueRef = element.getAttribute(attribute);
        }
        builder.addPropertyReference(attribute, valueRef);
    }
}

