/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public final class AuthorizationManagerBeforeMethodInterceptor
implements AuthorizationAdvisor {
    private Supplier<SecurityContextHolderStrategy> securityContextHolderStrategy = SecurityContextHolder::getContextHolderStrategy;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pointcut pointcut;
    private final AuthorizationManager<MethodInvocation> authorizationManager;
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private int order = AuthorizationInterceptorsOrder.FIRST.getOrder();
    private AuthorizationEventPublisher eventPublisher = AuthorizationManagerBeforeMethodInterceptor::noPublish;

    public AuthorizationManagerBeforeMethodInterceptor(Pointcut pointcut, AuthorizationManager<MethodInvocation> authorizationManager) {
        Assert.notNull((Object)pointcut, "pointcut cannot be null");
        Assert.notNull(authorizationManager, "authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    public static AuthorizationManagerBeforeMethodInterceptor preAuthorize() {
        return AuthorizationManagerBeforeMethodInterceptor.preAuthorize(new PreAuthorizeAuthorizationManager());
    }

    public static AuthorizationManagerBeforeMethodInterceptor preAuthorize(PreAuthorizeAuthorizationManager authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PreAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.PRE_AUTHORIZE.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerBeforeMethodInterceptor preAuthorize(AuthorizationManager<MethodInvocation> authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PreAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.PRE_AUTHORIZE.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerBeforeMethodInterceptor secured() {
        return AuthorizationManagerBeforeMethodInterceptor.secured(new SecuredAuthorizationManager());
    }

    public static AuthorizationManagerBeforeMethodInterceptor secured(SecuredAuthorizationManager authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(Secured.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.SECURED.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerBeforeMethodInterceptor secured(AuthorizationManager<MethodInvocation> authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(Secured.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.SECURED.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerBeforeMethodInterceptor jsr250() {
        return AuthorizationManagerBeforeMethodInterceptor.jsr250(new Jsr250AuthorizationManager());
    }

    public static AuthorizationManagerBeforeMethodInterceptor jsr250(Jsr250AuthorizationManager authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(RolesAllowed.class, DenyAll.class, PermitAll.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.JSR250.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerBeforeMethodInterceptor jsr250(AuthorizationManager<MethodInvocation> authorizationManager) {
        AuthorizationManagerBeforeMethodInterceptor interceptor = new AuthorizationManagerBeforeMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(RolesAllowed.class, DenyAll.class, PermitAll.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.JSR250.getOrder());
        return interceptor;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        return this.attemptAuthorization(mi);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAuthorizationEventPublisher(AuthorizationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, "eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public Advice getAdvice() {
        return this;
    }

    @Override
    public boolean isPerInstance() {
        return true;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.securityContextHolderStrategy = () -> securityContextHolderStrategy;
    }

    private Object attemptAuthorization(MethodInvocation mi) throws Throwable {
        AuthorizationDecision decision;
        this.logger.debug(LogMessage.of(() -> "Authorizing method invocation " + mi));
        try {
            decision = this.authorizationManager.check(this::getAuthentication, mi);
        }
        catch (AuthorizationDeniedException denied) {
            return this.handle(mi, denied);
        }
        this.eventPublisher.publishAuthorizationEvent(this::getAuthentication, mi, decision);
        if (decision != null && !decision.isGranted()) {
            this.logger.debug(LogMessage.of(() -> "Failed to authorize " + mi + " with authorization manager " + this.authorizationManager + " and decision " + decision));
            return this.handle(mi, decision);
        }
        this.logger.debug(LogMessage.of(() -> "Authorized method invocation " + mi));
        return this.proceed(mi);
    }

    private Object proceed(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (AuthorizationDeniedException ex) {
            AuthorizationManager<MethodInvocation> authorizationManager = this.authorizationManager;
            if (authorizationManager instanceof MethodAuthorizationDeniedHandler) {
                MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)authorizationManager);
                return handler.handleDeniedInvocation(mi, ex);
            }
            return this.defaultHandler.handleDeniedInvocation(mi, ex);
        }
    }

    private Object handle(MethodInvocation mi, AuthorizationDeniedException denied) {
        AuthorizationManager<MethodInvocation> authorizationManager = this.authorizationManager;
        if (authorizationManager instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)authorizationManager);
            return handler.handleDeniedInvocation(mi, denied);
        }
        return this.defaultHandler.handleDeniedInvocation(mi, denied);
    }

    private Object handle(MethodInvocation mi, AuthorizationResult decision) {
        AuthorizationManager<MethodInvocation> authorizationManager = this.authorizationManager;
        if (authorizationManager instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)authorizationManager);
            return handler.handleDeniedInvocation(mi, decision);
        }
        return this.defaultHandler.handleDeniedInvocation(mi, decision);
    }

    private Authentication getAuthentication() {
        Authentication authentication = this.securityContextHolderStrategy.get().getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
        }
        return authentication;
    }

    private static <T> void noPublish(Supplier<Authentication> authentication, T object, AuthorizationDecision decision) {
    }
}

