/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.provisioning;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.UserDetailsManagerConfigurer;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.provisioning.JdbcUserDetailsManager;

public class JdbcUserDetailsManagerConfigurer<B extends ProviderManagerBuilder<B>>
extends UserDetailsManagerConfigurer<B, JdbcUserDetailsManagerConfigurer<B>> {
    private DataSource dataSource;
    private List<Resource> initScripts = new ArrayList<Resource>();

    public JdbcUserDetailsManagerConfigurer(JdbcUserDetailsManager manager) {
        super(manager);
    }

    public JdbcUserDetailsManagerConfigurer() {
        this(new JdbcUserDetailsManager());
    }

    public JdbcUserDetailsManagerConfigurer<B> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.getUserDetailsService().setDataSource(dataSource);
        return this;
    }

    public JdbcUserDetailsManagerConfigurer<B> usersByUsernameQuery(String query) {
        this.getUserDetailsService().setUsersByUsernameQuery(query);
        return this;
    }

    public JdbcUserDetailsManagerConfigurer<B> authoritiesByUsernameQuery(String query) {
        this.getUserDetailsService().setAuthoritiesByUsernameQuery(query);
        return this;
    }

    public JdbcUserDetailsManagerConfigurer<B> groupAuthoritiesByUsername(String query) {
        JdbcUserDetailsManager userDetailsService = this.getUserDetailsService();
        userDetailsService.setEnableGroups(true);
        userDetailsService.setGroupAuthoritiesByUsernameQuery(query);
        return this;
    }

    public JdbcUserDetailsManagerConfigurer<B> rolePrefix(String rolePrefix) {
        this.getUserDetailsService().setRolePrefix(rolePrefix);
        return this;
    }

    public JdbcUserDetailsManagerConfigurer<B> userCache(UserCache userCache) {
        this.getUserDetailsService().setUserCache(userCache);
        return this;
    }

    @Override
    protected void initUserDetailsService() throws Exception {
        if (!this.initScripts.isEmpty()) {
            this.getDataSourceInit().afterPropertiesSet();
        }
        super.initUserDetailsService();
    }

    @Override
    public JdbcUserDetailsManager getUserDetailsService() {
        return (JdbcUserDetailsManager)super.getUserDetailsService();
    }

    public JdbcUserDetailsManagerConfigurer<B> withDefaultSchema() {
        this.initScripts.add(new ClassPathResource("org/springframework/security/core/userdetails/jdbc/users.ddl"));
        return this;
    }

    protected DatabasePopulator getDatabasePopulator() {
        ResourceDatabasePopulator dbp = new ResourceDatabasePopulator();
        dbp.setScripts(this.initScripts.toArray(new Resource[0]));
        return dbp;
    }

    private DataSourceInitializer getDataSourceInit() {
        DataSourceInitializer dsi = new DataSourceInitializer();
        dsi.setDatabasePopulator(this.getDatabasePopulator());
        dsi.setDataSource(this.dataSource);
        return dsi;
    }
}

