/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;

public class RegularGroupFormatter
extends NumericGroupFormatter {
    private final int groupSize;
    private final String groupSeparator;

    public RegularGroupFormatter(int grpSize, String grpSep, UnicodeString adjustedPicture) {
        this.groupSize = grpSize;
        this.groupSeparator = grpSep;
        this.adjustedPicture = adjustedPicture;
    }

    @Override
    public String format(String value) {
        if (this.groupSize > 0 && this.groupSeparator.length() > 0) {
            UnicodeString valueEx = StringView.tidy(value);
            StringBuilder temp = new StringBuilder(16);
            int i2 = valueEx.length32() - 1;
            int j = 0;
            while (i2 >= 0) {
                if (j != 0 && j % this.groupSize == 0) {
                    temp.insert(0, this.groupSeparator);
                }
                StringTool.prependWideChar(temp, valueEx.codePointAt(i2));
                --i2;
                ++j;
            }
            return temp.toString();
        }
        return value.toString();
    }

    @Override
    public String getSeparator() {
        return this.groupSeparator;
    }
}

